/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.criteria.impl;

import com.adaptavist.confluence.forums.model.datatypes.DataTypeManager;
import com.adaptavist.confluence.forums.service.search.criteria.SearchQueryTranslator;
import com.adaptavist.confluence.forums.service.search.criteria.impl.AbstractSearchCriteriaConverter;
import com.adaptavist.confluence.forums.service.search.query.HotTopicsQuery;
import com.adaptavist.confluence.forums.service.search.query.WatchedTopicsQuery;
import com.adaptavist.confluence.forums.service.search.sort.ForumSearchSortManager;
import com.adaptavist.confluence.forums.service.search.sort.ForumSearchSortOptions;
import com.adaptavist.confluence.forums.view.beans.search.topics.Filter;
import com.adaptavist.confluence.forums.view.beans.search.topics.FilterValueType;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchCriteria;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.MultiTextFieldQuery;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TopicSearchCriteriaConverter
extends AbstractSearchCriteriaConverter<TopicSearchCriteria> {
    private final DataTypeManager dataTypeManager;
    private final ForumSearchSortManager sortManager;
    private final SearchQueryTranslator queryTranslator;
    private final NotificationManager notificationManager;

    @Autowired
    public TopicSearchCriteriaConverter(DataTypeManager dataTypeManager, ForumSearchSortManager sortManager, SearchQueryTranslator queryTranslator, @ComponentImport NotificationManager notificationManager, @ComponentImport UserAccessor userAccessor) {
        super(userAccessor);
        this.dataTypeManager = dataTypeManager;
        this.sortManager = sortManager;
        this.queryTranslator = queryTranslator;
        this.notificationManager = notificationManager;
    }

    @Override
    public Class<TopicSearchCriteria> searchCriteriaType() {
        return TopicSearchCriteria.class;
    }

    @Override
    protected void mustQueries(List<SearchQuery> mustQueries, TopicSearchCriteria searchCriteria) {
        Set<String> searchKeys = searchCriteria.getSearchKeys();
        String searchText = searchCriteria.getSearchText();
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)searchText)) {
            searchText = this.formatSearchText(searchText);
        }
        if (searchCriteria.isSearchComments() && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)searchText)) {
            searchKeys.add("topicComment");
        }
        this.addQuery(mustQueries, this.topicQueries());
        this.addQuery(mustQueries, this.searchTextQuery(searchText, searchKeys));
        this.addQuery(mustQueries, this.recursiveQuery(searchCriteria.getForumId(), searchCriteria.getIncludeSubTopics()));
        if (searchCriteria.getIncludeLockedTopics() && !searchCriteria.getIncludeUnlockedTopics() || !searchCriteria.getIncludeLockedTopics() && searchCriteria.getIncludeUnlockedTopics()) {
            this.addQuery(mustQueries, this.fieldQuery("forumIndexPageIsLockedInt", searchCriteria.getIncludeLockedTopics() ? "1" : "0"));
        }
    }

    private String formatSearchText(String searchText) {
        searchText = searchText.trim();
        int valueOfAsterisk = searchText.indexOf("*");
        while (valueOfAsterisk == 0) {
            searchText = searchText.substring(1, searchText.length());
            valueOfAsterisk = searchText.indexOf("*");
        }
        return searchText;
    }

    @Override
    protected void mustNotQueries(List<SearchQuery> mustNotQueries, TopicSearchCriteria searchCriteria) {
        this.addQuery(mustNotQueries, this.skipConfluencePagesQuery(searchCriteria.getForumId()));
    }

    @Override
    protected void filterQueries(List<SearchQuery> mustQueries, TopicSearchCriteria searchCriteria) {
        for (Filter forumFilter : searchCriteria.getFilters()) {
            String dataItemName = forumFilter.getKey();
            List<String> filterValues = forumFilter.getValues();
            FilterValueType valueType = forumFilter.getValueType();
            SearchQuery filterQuery = this.dataTypeManager.getSearchQuery(dataItemName, filterValues, valueType);
            this.addQuery(mustQueries, filterQuery);
        }
        if (searchCriteria.getIncludeWatchedTopics()) {
            this.addQuery(mustQueries, new WatchedTopicsQuery(this.notificationManager));
        }
        if (searchCriteria.getIncludeHotTopics()) {
            this.addQuery(mustQueries, new HotTopicsQuery(searchCriteria.getActivityIndicatorThreshold()));
        }
    }

    @Override
    protected SearchSort getSearchSort(TopicSearchCriteria searchCriteria) {
        String dataItemName = searchCriteria.getSortKey();
        if (StringUtils.isNotBlank((String)dataItemName)) {
            SearchSort.Order sortOrder = searchCriteria.getSortOrder().toSortOrder();
            boolean sortStickyOnTop = searchCriteria.isSortStickyOnTop();
            String sortKey = this.dataTypeManager.getDataItemType(dataItemName).getSearchSortKey();
            return this.sortManager.getForumSorter(sortKey, sortOrder, ForumSearchSortOptions.sortOptions(sortStickyOnTop));
        }
        return null;
    }

    private SearchQuery searchTextQuery(String searchText, Set<String> searchKeys) {
        String translatedSearchText = this.queryTranslator.translateQuery(searchText);
        if (StringUtils.isNotBlank((String)translatedSearchText) && CollectionUtils.isNotEmpty(searchKeys)) {
            Set<String> searchKeysIndexes = this.queryTranslator.translateSearchKeys(searchKeys);
            return new MultiTextFieldQuery(translatedSearchText, searchKeysIndexes, BooleanOperator.AND);
        }
        return null;
    }
}

