/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.criteria.impl;

import com.adaptavist.confluence.forums.service.search.criteria.impl.AbstractSearchCriteriaConverter;
import com.adaptavist.confluence.forums.service.search.sort.ForumSearchSort;
import com.adaptavist.confluence.forums.service.search.sort.ForumSearchSortManager;
import com.adaptavist.confluence.forums.service.search.sort.ForumSearchSortOptions;
import com.adaptavist.confluence.forums.view.beans.search.content.ContentSearchCriteria;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentSearchCriteriaConverter
extends AbstractSearchCriteriaConverter<ContentSearchCriteria> {
    private static final String STICKY_ON_TOP = "sortStickyOnTop";
    private static final String SORT_OPTION = "sortBy";
    private static final String ALPHA_DESC_SORT = "alphabetic-descending";
    private static final String LASTEST_ACTIVITY_SORT = "last-activity";
    private final ForumSearchSortManager searchSortManager;

    @Autowired
    public ContentSearchCriteriaConverter(ForumSearchSortManager searchSortManager, @ComponentImport UserAccessor userAccessor) {
        super(userAccessor);
        this.searchSortManager = searchSortManager;
    }

    @Override
    public Class<ContentSearchCriteria> searchCriteriaType() {
        return ContentSearchCriteria.class;
    }

    @Override
    protected void mustQueries(List<SearchQuery> mustQueries, ContentSearchCriteria searchCriteria) {
        this.addQuery(mustQueries, this.contentTypeQueries(searchCriteria.getContentType()));
        if (ContentSearchCriteria.SearchScope.SPACE.equals((Object)searchCriteria.getSearchScope())) {
            this.addQuery(mustQueries, this.inSpaceQuery(searchCriteria.getSpaceKey()));
        } else {
            this.addQuery(mustQueries, this.recursiveQuery(searchCriteria.getRootPageId(), searchCriteria.isRecursive()));
        }
    }

    @Override
    protected void mustNotQueries(List<SearchQuery> mustNotQueries, ContentSearchCriteria searchCriteria) {
        if (ContentSearchCriteria.SearchScope.PAGE.equals((Object)searchCriteria.getSearchScope())) {
            this.addQuery(mustNotQueries, this.skipConfluencePagesQuery(searchCriteria.getRootPageId()));
        }
    }

    @Override
    protected void filterQueries(List<SearchQuery> mustQueries, ContentSearchCriteria searchCriteria) {
    }

    @Override
    protected SearchSort getSearchSort(ContentSearchCriteria searchCriteria) {
        Map<String, String> options = searchCriteria.getOptions();
        ForumSearchSort searchSort = null;
        if (ContentSearchCriteria.ContentType.TOPIC.equals((Object)searchCriteria.getContentType())) {
            boolean sortStickyOnTop = Boolean.parseBoolean(options.get(STICKY_ON_TOP));
            ForumSearchSortOptions sortOptions = ForumSearchSortOptions.sortOptions(sortStickyOnTop);
            searchSort = this.searchSortManager.getForumSorter("forum-sort-lastactivitydate", SearchSort.Order.DESCENDING, sortOptions);
        } else if (ContentSearchCriteria.ContentType.FORUM.equals((Object)searchCriteria.getContentType())) {
            SearchSort.Order order;
            String sortKey;
            String sortStickyOnTop = options.get(SORT_OPTION);
            if (LASTEST_ACTIVITY_SORT.equalsIgnoreCase(sortStickyOnTop)) {
                sortKey = "forum-sort-lastactivitydate";
                order = SearchSort.Order.DESCENDING;
            } else if (ALPHA_DESC_SORT.equalsIgnoreCase(sortStickyOnTop)) {
                sortKey = "forum-sort-title";
                order = SearchSort.Order.DESCENDING;
            } else {
                sortKey = "forum-sort-title";
                order = SearchSort.Order.ASCENDING;
            }
            searchSort = this.searchSortManager.getForumSorter(sortKey, order);
        }
        return searchSort;
    }

    private SearchQuery[] contentTypeQueries(ContentSearchCriteria.ContentType contentType) {
        if (ContentSearchCriteria.ContentType.FORUM.equals((Object)contentType)) {
            return this.forumQueries();
        }
        return this.topicQueries();
    }
}

