/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.impl;

import com.adaptavist.confluence.forums.dao.ao.entity.PermissionsConfig;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionsSupport {
    private final PermissionManager permissionManager;
    private final SpacePermissionManager spacePermissionManager;

    @Autowired
    public PermissionsSupport(@ComponentImport PermissionManager permissionManager, @ComponentImport SpacePermissionManager spacePermissionManager) {
        this.permissionManager = permissionManager;
        this.spacePermissionManager = spacePermissionManager;
    }

    public boolean hasPermission(PermissionsConfig.PermissionType permissionType, User user, AbstractPage page) {
        if (permissionType == null || user == null || page == null) {
            return false;
        }
        if (PermissionsConfig.PermissionType.PAGE_EDIT.equals((Object)permissionType)) {
            return this.permissionManager.hasPermission(user, Permission.EDIT, (Object)page);
        }
        if (PermissionsConfig.PermissionType.SPACE_ADMIN.equals((Object)permissionType)) {
            return this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", page.getSpace(), user);
        }
        return false;
    }

    public boolean hasEditPermission(User user, Object target) {
        return this.permissionManager.hasPermission(user, Permission.EDIT, target);
    }

    public boolean hasViewPermission(User user, Object target) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, target);
    }

    public boolean hasViewPagePermission(User user, AbstractPage page) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, (Object)page);
    }

    public boolean hasViewSpacePermission(User user, Space space) {
        return this.spacePermissionManager.hasPermission("VIEWSPACE", space, user);
    }

    public boolean hasEditPermission(User user, Class targetType) {
        return this.permissionManager.hasPermission(user, Permission.EDIT, targetType);
    }

    public boolean hasViewPermission(User user, Class targetType) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, targetType);
    }

    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    public SpacePermissionManager getSpacePermissionManager() {
        return this.spacePermissionManager;
    }
}

