/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.analytic.event;

import com.adaptavist.analytic.concurrent.ExecutorServiceManager;
import com.adaptavist.analytic.metadata.PluginMetadataProvider;
import com.adaptavist.analytic.model.Analytic;
import com.adaptavist.analytic.model.SegmentTrackAnalytic;
import com.adaptavist.analytic.service.AnalyticService;
import com.adaptavist.confluence.forums.model.AnalyticsEventData;
import com.adaptavist.confluence.forums.service.analytic.event.AnalyticMetricsBuilder;
import com.adaptavist.confluence.forums.service.analytic.event.AnalyticStrategy;
import com.adaptavist.confluence.forums.service.analytic.event.UserAnalyticMetrics;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.api.license.LicenseHandler;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SegmentAnalyticStrategy
implements AnalyticStrategy {
    private static final String NO_SPACE_DEFINED = "no-space-defined";
    private final AnalyticService analyticService;
    private final ExecutorServiceManager executorServiceManager;
    private final PluginMetadataProvider pluginMetadataProvider;
    private final UserAnalyticMetrics userAnalyticMetrics;
    private final LicenseHandler licenseHandler;

    @Autowired
    public SegmentAnalyticStrategy(AnalyticService analyticService, UserAnalyticMetrics userAnalyticMetrics, @ComponentImport ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, @Qualifier(value="pluginMetadataProvider") PluginMetadataProvider pluginMetadataProvider, @ComponentImport LicenseHandler licenseHandler) {
        this.analyticService = analyticService;
        this.executorServiceManager = new ExecutorServiceManager(threadLocalDelegateExecutorFactory);
        this.userAnalyticMetrics = userAnalyticMetrics;
        this.pluginMetadataProvider = pluginMetadataProvider;
        this.licenseHandler = licenseHandler;
    }

    @Override
    public void reportEventAnalytics(AbstractPage page, String eventName, String eventType) {
        this.executorServiceManager.getExecutorService().submit(() -> {
            Space space = page.getSpace();
            AnalyticsEventData analyticsEventData = AnalyticsEventData.builder().eventType(eventType).space(space).build();
            Map<String, String> analyticData = this.extractAnalyticsData(analyticsEventData);
            this.trackAnalytics(analyticData, eventName);
        });
    }

    @Override
    public void reportEventAnalytics(ConversionContext conversionContext, String eventName, String eventType) {
        this.executorServiceManager.getExecutorService().submit(() -> {
            ContentEntityObject entity = conversionContext.getEntity();
            Space space = entity == null ? null : ((AbstractPage)entity).getSpace();
            AnalyticsEventData analyticsEventData = AnalyticsEventData.builder().eventType(eventType).space(space).build();
            Map<String, String> analyticData = this.extractAnalyticsData(analyticsEventData);
            this.trackAnalytics(analyticData, eventName);
        });
    }

    private Map<String, String> extractAnalyticsData(AnalyticsEventData analyticsEventData) {
        Space space = analyticsEventData.getSpace();
        return new AnalyticMetricsBuilder().setAction(analyticsEventData.getEventType()).setSpaceType(space != null ? space.getSpaceType().toString() : NO_SPACE_DEFINED).setSpaceID(space != null ? String.valueOf(space.getKey().hashCode()) : NO_SPACE_DEFINED).setTriggeredBy(this.userAnalyticMetrics.getUserHashCode()).setUserType(this.userAnalyticMetrics.getUserType(space)).setUserID(this.licenseHandler.getServerId()).setGroupID(this.licenseHandler.getServerId()).build();
    }

    private void trackAnalytics(Map<String, String> analyticData, String eventName) {
        SegmentTrackAnalytic analytic = new SegmentTrackAnalytic(this.pluginMetadataProvider.get().getSupportEntitlementNumber(), eventName, analyticData);
        this.analyticService.track((Analytic)analytic);
    }
}

