/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.model.module;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractForumModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private static final String KEY = "key";

    public AbstractForumModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
    }

    public Void getModule() {
        return null;
    }

    protected void assertKeyPresent(Element element) {
        if (StringUtils.isEmpty((String)this.getElementKey(element))) {
            throw new PluginParseException("Module key must be specified for '" + this.getElementTag(element) + "'!");
        }
    }

    protected void assertChildElementPresent(Element parent, String childName) {
        if (this.getChildElement(parent, childName) == null) {
            throw new PluginParseException("Child element '" + childName + "' missing for module key '" + this.getElementKey(parent) + "'!");
        }
    }

    protected void assertAttributePresent(Element element, String attrName) {
        if (StringUtils.isEmpty((String)this.getAttribute(element, attrName))) {
            throw new PluginParseException("'" + attrName + "' missing for module key '" + this.getElementKey(element) + "'!");
        }
    }

    protected String getElementKey(Element element) {
        return this.getAttribute(element, KEY);
    }

    protected String getAttribute(Element element, String attrName) {
        return element != null ? element.attributeValue(attrName) : null;
    }

    protected boolean getBooleanAttribute(Element element, String attrName, boolean defaultValue) {
        String value = this.getAttribute(element, attrName);
        return StringUtils.isBlank((String)value) ? defaultValue : Boolean.valueOf(value);
    }

    protected List<String> getListAttribute(Element element, String attrName) {
        String values = this.getAttribute(element, attrName);
        if (StringUtils.isNotBlank((String)values)) {
            return Arrays.asList(values.split("\\s*[,;]\\s*"));
        }
        return Collections.emptyList();
    }

    protected String getElementTag(Element element) {
        return element != null ? element.getName() : null;
    }

    protected Element getChildElement(Element parent, String childName) {
        return parent != null ? parent.element(childName) : null;
    }

    protected List<Element> getChildElements(Element parent, String childName) {
        return parent != null ? parent.elements(childName) : Collections.emptyList();
    }
}

