/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.rest;

import com.adaptavist.confluence.forums.view.beans.template.TemplateView;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/template")
@Produces(value={"application/json"})
public class ForumTemplateResource {
    private final PageTemplateManager templateManager;
    private final SpaceManager spaceManager;

    @Inject
    public ForumTemplateResource(@ComponentImport PageTemplateManager templateManager, @ComponentImport SpaceManager spaceManager) {
        this.templateManager = templateManager;
        this.spaceManager = spaceManager;
    }

    @GET
    public Response getStickyStatus(@QueryParam(value="templateName") String templateName, @QueryParam(value="spaceKey") String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        List templates = this.templateManager.getGlobalPageTemplates();
        templates.addAll(this.templateManager.getPageTemplates(space));
        HashSet noDuplicateTemplates = new HashSet(templates);
        ArrayList<TemplateView> templateList = new ArrayList<TemplateView>();
        for (PageTemplate template : noDuplicateTemplates) {
            if (!StringUtils.containsIgnoreCase((String)template.getName(), (String)templateName)) continue;
            templateList.add(new TemplateView(template.getId(), template.getName()));
        }
        return Response.ok(templateList).build();
    }
}

