import React from 'react';
import { ThemeProvider, createGlobalStyle } from 'styled-components';
import { AppContainer } from 'react-hot-loader';
import { ScreenClassProvider }  from 'react-grid-system';
import Redbox from 'redbox-react';

import App from './App';
import { ROOT_ELEMENT_ID } from './index';
import { theme } from './config';
import { AJS } from "./utils";

const Root: React.FunctionComponent = (props) => {
    return (
        <AppContainer errorReporter={CustomErrorReporter}>
            <ScreenSizeProvider>
                <ThemeProvider theme={theme}>
                    <>
                        <GlobalStyles/>
                        <App />
                    </>
                </ThemeProvider>
            </ScreenSizeProvider>
        </AppContainer>
    )
}

export default Root;

const CustomErrorReporter = ({ error }) => <Redbox error={error} />;
const fontFile = (filename) => `url(${AJS.contextPath()}/download/resources/com.adaptavist.confluence.forums/public/fonts/${filename})`;

const GlobalStyles = createGlobalStyle`
    h3 { font-size: 16.5px }
    a { text-decoration: none !important; }
    // Removes the default border around the getting started page
    #main, #main-header {
        padding: 0 !important;
        margin-bottom: 0 !important;
    }
    
    // Removes the extra text generated by creating a < title > element in the gettingstarted.vm file 
    #title-text {
      display: none !important;
    }
    
    #${ROOT_ELEMENT_ID} {
        font-family: 'MuseoSans', -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen", "Ubuntu", "Fira Sans", "Droid Sans", "Helvetica Neue", sans-serif;
        color: ${theme.textColor};
        font-size: 14.2px;
        padding-bottom: 4em;
    }
    
    @font-face {
        font-family: 'MuseoSans';
        font-weight: normal;
        src: ${fontFile("MuseoSans-300.otf")} format("opentype");
    }
    
    @font-face {
        font-family: 'MuseoSans';
        font-weight: 500;
        src: ${fontFile("MuseoSans-500.otf")} format("opentype");
    }
    
    @font-face {
        font-family: 'MuseoSans';
        font-weight: bold;
        src: ${fontFile("MuseoSans-700.otf")} format("opentype");
    }
    
    @font-face {
        font-family: 'MuseoSans';
        font-weight: 900;
        src: ${fontFile("MuseoSans-900.otf")} format("opentype");
    }
`

const ScreenSizeProvider = ScreenClassProvider as any; // Fixes a type bug
