import React from "react";
import {
    GettingStartedPage,
    Button,
    CallToAction,
    LearnMoreCards,
    Section,
    SupportBox,
    Link
} from 'adaptavist-components';
import { AJS } from './utils';
import { theme } from './config';

import styled from "styled-components";
import { Star } from 'styled-icons/typicons/Star'
import { Flag } from 'styled-icons/typicons/Flag'
import { Users } from 'styled-icons/fa-solid/Users'

const imagePath = (filename) => `${AJS.contextPath()}/download/resources/com.adaptavist.confluence.forums/public/images/${filename}`
const headerIcon = <img src={imagePath('forms-logo.svg')}/>

const learnMoreCardConfigs = [
    { href: 'https://docs.adaptavist.com/x/lJAOBg', target: '_blank', description: "Creating a New Forum", imgSrc: imagePath('learn_more_1.png')},
    { href: 'https://docs.adaptavist.com/x/lpAOBg', target: '_blank', description: "Working with Topics", imgSrc: imagePath('learn_more_2.png')},
    { href: 'https://docs.adaptavist.com/x/wJAOBg', target: '_blank', description: "Forums Administration", imgSrc: imagePath('learn_more_3.png')},
]

const links = {
    emailTemplateSpaceAdmin: 'https://docs.adaptavist.com/x/YJAOBg', //Space Admin & Confluence Admin sections are in same page.
    emailTemplateForumUsers: 'https://docs.adaptavist.com/x/YJAOBg',
    support: 'https://productsupport.adaptavist.com/servicedesk/customer/portal/4',
    documentation: 'https://docs.adaptavist.com/x/ppAOBg',
    adminMenu: `${AJS.contextPath()}/plugins/forums/config/global/forumGlobalConfiguration.action`
}

const ProductLogo = () => <img src={imagePath('forums_logo.png')} />;
const AdaptavistLogo = () => <img src={imagePath('adaptavist-logo.png')} />;
const CallToActionImage = styled((props) => <img src={imagePath('paper-plane.png')} {...props}/>)`
  float: right;
  padding-left: 8px;
  width: 80px;
  margin-bottom: 8px;
`

export const App = (props) => (
    <GettingStartedPage
        title="Welcome to Community Forums for Confluence"
        headerIcon={<ProductLogo />}
        sidebarContent={<Sidebar />}
        className={props.className}
    >
        <Section title="Get Started with Community Forums for Confluence" className="gettoknow" titleAs="h2">
            <p>Thank you for installing Community Forums for Confluence!</p>
            <p>You and your teams are just a few steps away from discussing important topics more effectively and collaborating more easily.
                To get started using Community Forums, please take a look at the guides below.</p>
        </Section>
        <Section title="Get to Know Community Forums" className="learnmore">
            <p>Learn where to find and use our forum blueprint, our step-by-step feature that takes users through
                setting up a forum, with the Creating a New Forum guide below.
                The Working with Topics guide shows you how to create, view, and manage topics.
                Finally, the Forums Administration guide shows you how to maximise your team's use
                of the app and get control of how the app is used.
            </p>
            <p>Use the links below to find out more.</p>
            <LearnMoreCards centered cardData={learnMoreCardConfigs} cardWidth={168}/>
        </Section>
        <CallToAction title="Key Info for Admins" width={750}
          description={[
              <p key={1}>Before your teams start using Community Forums there are a couple of quick things you can do to
                  ensure they get the most out of the app.
                  From the <Link href={links.adminMenu} text="Community Forums Configuration menu"/> in Confluence Administration you can:</p>,
              <ul key={2}>
                  <li>Add a Forums menu to your instance to enhance visibility and accessibility.</li>
                  <li>Set global permissions for sticky topics, removing topics, and locking forums and topics,
                      then choose whether to allow space admins to override these permissions for their space.</li>
              </ul>
          ]}
          icon={<KeyInfoIcon />}
          image={ <img width="140px" src={imagePath('cog-stroll.png')}/> }
        />
    </GettingStartedPage>
)

export default styled(App)`
  .learnmore {
      i {
        font-weight: 600;
      }
  }
  .calltoaction {
    padding: 2em 2.5em;
  }
`


const Sidebar = (props) => (
    <>
        <CallToAction
            width={500}
            title="Get Everyone Onboard!"
            button={
                <InlineFlex>
                    <PrimaryButton link={links.emailTemplateForumUsers} value='Forum User Onboarding' shouldFitContainer/>
                    <PrimaryButton link={links.emailTemplateSpaceAdmin} value='Space Admin Onboarding' shouldFitContainer/>
                </InlineFlex>
            }
            icon={<OnboardIcon />}
            className='calltoaction'
        >
            <CallToActionImage />
            <p>We'd love your teams to use Community Forums as soon as possible, so we've put together email templates
                that you can forward. The forum user email template has all the essential info that will get them
                started using their first forum. The space admin template highlights the space admin tools including
                setting permissions for locking and removing topics and making topics sticky.</p>
        </CallToAction>
        <SupportBox
            title="Here to Help"
            icon={<SupportBoxIcon />}
            supportLinks={<InlineFlex>
                <SecondaryButton value="Support" href={links.support} />
                <SecondaryButton value="Documentation" href={links.documentation} />
            </InlineFlex>}
            logo={<AdaptavistLogo />}
        >
            <p>We want you to get the most out of Community Forums, so if you’ve got a question for us,
                are trying to figure out how to set something up, or have any ways that we can improve the app,
                please feel free to contact us or take a look at our documentation.
            </p>
        </SupportBox>
    </>
)

const PrimaryButton = styled<any>((props) => (
    <Button appearance='primary'
        theme={theme}
        href={props.link} target="_blank"
        {...props}
    >{
        props.value || props.children
    }</Button>
))``

const SecondaryButton = styled<any>((props) => (
    <Button appearance="default"
        shouldFitContainer
        theme={theme}
        href={props.link} target="_blank"
        {...props}

    >{
        props.value || props.children
    }</Button>
))``

const InlineFlex = styled<any>('div')`
  display: flex !important;
  flex-direction: column;
  margin: 1em 0;
  
  ${PrimaryButton} {
    align-self: start;
    margin-top: 8px;
  }
  
  ${SecondaryButton} {
    margin-top: 8px;
  }
`

const KeyInfoIcon = styled(Star)`
  && {
    height: 24px;
    top: -3px;
  }
`

const SupportBoxIcon = styled(Users)`
  && {
    height: 18px;
    margin-right: 2px;
    top: 0;
  }
`

const OnboardIcon = styled(Flag)`
    height: 22px !important;
`