var AJS = AJS || {};

/*
 * Functions for disabling locked pages edit/add/remove actions.
 */
AJS.LockedPageUtils = {

    title: '#title-text',
    currentPageLabel: '.ia-secondary-currentPage-title .label',
    createPageLink: '#create-page-button',
    createChildLink: '.create-child-page-link',
    itemChildLink: '.child-item a',
    editPageLink: '#editPageLink',
    viewPageLink: '#viewPageLink',
    movePageLink: '#action-move-page-dialog-link',
    removePageLink: '#action-remove-content-link',
    commentAction: '.comment-actions-primary li',
    newTopicButton: '#add-new-forum-topic-button',
    editAttachmentLabel: '.labels-edit-container a',
    attachmentActions: '.attachment-actions a',
    restforumMessages: '.restforumMessages',

    removeElement: function ($, selector) {
        var elem = $(selector);
        if (elem.length) {
            elem.remove();
        }
    },

    markAsLockedBefore: function ($, selector) {
        var elem = $(selector);
        if (elem.length) {
            elem.addClass("forum-icon-before");
            elem.addClass("locked");
        }
    },

    markAsLockedAfter: function ($, selector) {
        var elem = $(selector);
        if (elem.length) {
            elem.addClass("forum-icon-after");
            elem.addClass("locked");
        }
    },

    disableElement: function ($, selector) {
        var elem = $(selector);
        if (elem.length) {
            var elemClass = elem.attr('class');
            elem.replaceWith(function () {
                return $('<span onclick="return false;"' + elemClass + '" >' + $(this).html() + '</span>');
            });
        }
    },

    removeLinks: function ($, selector) {
        var elem = $(selector);
        $(elem).each(function(){
            if (elem.length && !$(this).hasClass('comment-date')) {
                $(this).remove();
            }
        });
    },

    linkToSpan: function ($, selector) {
        var elem = $(selector);
        if (elem.length) {
            elem.replaceWith(function () {
                return $('<span>' + $(this).html() + '</span>');
            });
        }
    }
};