// Functionality good without these checks, but following existing code
if (typeof Adaptavist == 'undefined') {
    var Adaptavist = {};
}
if (typeof Adaptavist.Forums == 'undefined') {
    Adaptavist.Forums = {};
}
if (typeof Adaptavist.Forums.Menu == 'undefined') {
    Adaptavist.Forums.Menu = {};
}

AJS.toInit(function () {

    var alreadyLoaded = false;

    /**
     * Function to set the local storage
     * @param item
     */
    function setStorageItem(item) {
        if (typeof (Storage) !== "undefined") {
            localStorage.setItem(item, "true");
        }
    }

    /**
     * Get local storage value for a given key
     * @param item
     */
    function getStorageItem(item) {
        if (typeof (Storage) !== "undefined") {
            return localStorage.getItem(item);
        }
    }

    function createHeaderMenuItem() {
        function addDropdownAttributes(link, name) {
            link.attr("aria-haspopup", "true");
            link.attr("aria-owns", name + "-menu-link-content")
            link.addClass("aui-nav-link");
            link.addClass("aui-dropdown2-trigger");
        }

        var forumsLink = AJS.$('a#forums-link');
        addDropdownAttributes(forumsLink, "forums");
        AJS.$('a#forums-link').after(Adaptavist.Forums.Menu.headermenu);
    }

    function createForumLinks(results) {
        var imageResourcePath = '/download/resources/com.adaptavist.confluence.forums:header-resources/images/forums-menu-icon.png';
        var forumsDirectoryPath = '/forumdirectory/view.action';

        AJS.$('#forums-header-links-menu-global').append(Adaptavist.Forums.Menu.createForumLinks({
            recentForums: results,
            contextPath: AJS.contextPath(),
            imageResourcePath: imageResourcePath
        }));

        AJS.$('#forums-menu-link-content').append(Adaptavist.Forums.Menu.createStaticLinks({
            contextPath: AJS.contextPath(),
            forumsDirectoryPath: forumsDirectoryPath
        }));

        alreadyLoaded = true;

        addOnClickEventToCreateForumLink();
    }

    function addOnClickEventToCreateForumLink() {
        if (isReadOnlyModeOn()) {
            hideCreateForumLink();
            return;
        }
        AJS.$('#create-forum-link').on('click', function () {
            var options = {};
            options['title'] = 'Create Forums';
            var space = AJS.Meta.get('space-key');
            loadConfluenceBlueprint(space, options);

        });
    }

    function isReadOnlyModeOn() {
        return AJS.Meta.get('access-mode') === 'READ_ONLY';
    }

    function hideCreateForumLink() {
        AJS.$('#create-forum-link').hide();
    }

    function loadConfluenceBlueprint(space, options) {
        if (!space) {
            loadConfluenceBlueprintWithNoSpace(options);
            return;
        }
        loadConfluenceBlueprintWithSpace(space, options);
    }

    function loadConfluenceBlueprintWithNoSpace(options) {
        if (parseFloat(AJS.Meta.get("version-number")) >= 5.8) {
            Confluence.Blueprint.loadDialogAndOpenTemplate(options);
            return;
        }
        Confluence.Blueprint.Dialog.launch(options);
    }

    function loadConfluenceBlueprintWithSpace(space, options) {
        options['spaceKey'] = space;
        Confluence.Blueprint.Dialog.requestWebItems(space, false).done(function (ev) {
            var configs = Confluence.Blueprint.Dialog.loadedWebitems[space];

            for (var i = 0; i < configs.length; i++) {
                if (configs[i].name === 'Community Forum') {
                    options['contentBlueprintId'] = configs[i].contentBlueprintId;
                    var version = AJS.Meta.get("version-number");
                    version = version.replace(/\./g, "");

                    if (parseInt(version) < 580) {
                        Confluence.Blueprint.Dialog.launch(options);
                    } else {
                        Confluence.Blueprint.loadDialogAndOpenTemplate(options);
                    }
                }
            }
        });
    }

    function fetchRecentForums() {
        AJS.$('#forums-link').on('click', function () {
            if (!alreadyLoaded) {
                AJS.$.ajax({
                    type: 'GET',
                    url: AJS.contextPath() + '/rest/forums/latest/search/recentForums',
                    contentType: 'application/json; charset=utf-8',
                    dataType: 'json'
                }).done(createForumLinks);
            }
        });
    }

    function verifyIfHeaderIsOn() {
        AJS.$.ajax({
            type: 'GET',
            url: AJS.contextPath() + '/rest/forums/latest/search/isForumHeaderOn',
            contentType: 'application/json; charset=utf-8',
            dataType: 'json'
        }).done(function (result) {
            if (result && AJS.Meta.get('remote-user') !== '') {// also checking if you are logged in.
                createHeaderMenuItem();
                fetchRecentForums();
            }
        });
    }

    //Verify if the Header is configured to be On. If yes, then populate the links
    verifyIfHeaderIsOn();
});
