if (Adaptavist === undefined) {
    var Adaptavist = {};
}
if (Adaptavist.Forums === undefined) {
    Adaptavist.Forums = {};
}
if (Adaptavist.Forums.Commons === undefined) {
    Adaptavist.Forums.Commons = {};
}

/**
 * Logic taken from https://github.com/MadMG/moment-jdateformatparser
 */

AJS.toInit(function ($) {

    var javaDateFormats = {};

    var javaFormatMapping = {
        d: 'D',
        dd: 'DD',
        yy: 'YY',
        yyyy: 'YYYY',
        a: 'a',
        A: 'A',
        M: 'M',
        MM: 'MM',
        MMM: 'MMM',
        MMMM: 'MMMM',
        h: 'h',
        hh: 'hh',
        H: 'H',
        HH: 'HH',
        m: 'm',
        mm: 'mm',
        s: 's',
        ss: 'ss',
        S: 'SSS',
        SS: 'SSS',
        SSS: 'SSS',
        E: 'ddd',
        EEEE: 'dddd',
        D: 'DDD',
        w: 'W',
        ww: 'WW',
        z: 'ZZ',
        zzzz: 'Z',
        Z: 'ZZ',
        X: 'ZZ',
        XX: 'ZZ',
        XXX: 'Z',
        u: 'E'
    };

    function translateFormat(formatString, mapping) {
        var len = formatString.length,
            i = 0,
            beginIndex = -1,
            lastChar = null,
            currentChar = "",
            resultString = "";

        for (; i < len; i++) {
            currentChar = formatString[i];

            if (lastChar === null || lastChar !== currentChar) {
                // change detected
                resultString = _appendMappedString(formatString, mapping, beginIndex, i, resultString);

                beginIndex = i;
            }

            lastChar = currentChar;
        }

        return _appendMappedString(formatString, mapping, beginIndex, i, resultString);
    }

    function _appendMappedString(formatString, mapping, beginIndex, currentIndex, resultString) {
        var tempString;

        if (beginIndex !== -1) {
            tempString = formatString.substring(beginIndex, currentIndex);
            // check if the temporary string has a known mapping
            if (mapping[tempString]) {
                tempString = mapping[tempString];
            }
            resultString = resultString.concat(tempString);
        }
        return resultString;
    }

    Adaptavist.Forums.Commons.JavaToJsDatePattern = function (formatString) {
        if (!javaDateFormats[formatString]) {
            javaDateFormats[formatString] = translateFormat(formatString, javaFormatMapping);
        }
        return javaDateFormats[formatString];
    };
});
