/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.macros.params;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.HtmlUtil;
import org.apache.commons.lang.StringUtils;

public class PageSpaceParam {
    private static final PageSpaceParam EMPTY = new PageSpaceParam(null, (String)null);
    private final Page page;
    private final Space space;
    private final String spaceKey;

    private PageSpaceParam(Page page, String spaceKey) {
        this.page = page;
        this.spaceKey = spaceKey;
        this.space = null;
    }

    private PageSpaceParam(Page page, Space space) {
        this(page, PageSpaceParam.spaceKeyOf(space), space);
    }

    private PageSpaceParam(Page page, String spaceKey, Space space) {
        this.page = page;
        this.spaceKey = spaceKey;
        this.space = space;
    }

    private static String spaceKeyOf(Space space) {
        return space != null ? space.getKey() : "";
    }

    public static PageSpaceParam pageSpaceKeyParam(Page page, String spaceKey) {
        return new PageSpaceParam(page, spaceKey);
    }

    public static PageSpaceParam pageSpaceParam(Page page, Space space) {
        return new PageSpaceParam(page, space);
    }

    public static PageSpaceParam spaceKeyParam(String spaceKey) {
        return new PageSpaceParam(null, spaceKey);
    }

    public static PageSpaceParam spaceParam(Space space) {
        return new PageSpaceParam(null, space);
    }

    public static PageSpaceParam spaceParam(String spaceKey, Space space) {
        return new PageSpaceParam(null, spaceKey, space);
    }

    public static PageSpaceParam emptyParams() {
        return EMPTY;
    }

    public Page getPage() {
        return this.page;
    }

    public long getPageId() {
        return this.hasPage() ? this.page.getId() : 0L;
    }

    public String getPageIdAsString() {
        return this.hasPage() ? this.page.getIdAsString() : "";
    }

    public String getPageTitle() {
        return this.hasPage() ? this.page.getTitle() : "";
    }

    public String getEncodedPageTitle() {
        return this.hasPage() ? HtmlUtil.urlEncode((String)this.page.getTitle()) : "";
    }

    public String getPageParentTitle() {
        return this.hasParent() ? this.page.getParent().getTitle() : "";
    }

    public String getPageParentIdAsString() {
        return this.hasParent() ? this.page.getParent().getIdAsString() : "";
    }

    public Space getSpace() {
        return this.space;
    }

    public String getSpaceKey() {
        return StringUtils.isNotBlank((String)this.spaceKey) ? this.spaceKey : "";
    }

    public boolean hasSpaceKey() {
        return StringUtils.isNotBlank((String)this.spaceKey);
    }

    public boolean hasSpace() {
        return this.space != null;
    }

    public boolean hasPage() {
        return this.page != null;
    }

    public boolean hasPageAndSpaceKey() {
        return this.hasPage() && this.hasSpaceKey();
    }

    private boolean hasParent() {
        return this.hasPage() && this.page.getParent() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageSpaceParam that = (PageSpaceParam)o;
        if (this.page != null ? !this.page.equals((Object)that.page) : that.page != null) {
            return false;
        }
        return !(this.spaceKey == null ? that.spaceKey != null : !this.spaceKey.equals(that.spaceKey));
    }

    public int hashCode() {
        int result = this.page != null ? this.page.hashCode() : 0;
        result = 31 * result + (this.spaceKey != null ? this.spaceKey.hashCode() : 0);
        return result;
    }
}

