/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.macros;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.ForumPrefsManager;
import com.adaptavist.confluence.forums.service.analytic.event.AnalyticStrategy;
import com.adaptavist.confluence.forums.view.macros.AbstractForumMacro;
import com.adaptavist.confluence.forums.view.macros.aggregator.MacroServiceAggregator;
import com.adaptavist.confluence.forums.view.macros.params.PageSpaceParam;
import com.adaptavist.confluence.forums.view.macros.velocity.builder.VelocityContextBuilder;
import com.adaptavist.confluence.support.LicensingSupport;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Qualifier;

public class RestForumMacro
extends AbstractForumMacro {
    public static final String PARAM_PAGE_SPACE = "pageAndSpace";
    public static final String BACKGROUND_COLOR = "backgroundColor";
    public static final String TEXT_COLOR = "textColor";
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_TEMPLATE_PAGE_ID = "templatePageId";
    public static final String PARAM_BODY = "body";
    public static final String PARAM_PREFS = "prefs";
    public static final String PARAM_STICKY_ON_TOP = "stickyOnTop";
    public static final String PARAM_NEW_TOPIC_LABEL = "createTopicLabel";
    public static final String PARAM_PAGE_SIZE = "pageSize";
    public static final String PARAM_RECURSE = "recurse";
    public static final String PARAM_EXCERPT = "showExcerpt";
    public static final String FORUM_SUMMARY_NOTIFICATION = "forumSummaryNotification";
    private static final String REST_FORUM_MACRO_TEMPLATE = "forum/templates/vm/rest-forum-macro.vm";
    private static final String IS_VIEW_MODE_ONLY = "isViewModeOnly";
    private static final String IS_DC_IN_READ_ONLY_MODE = "isDcInReadOnlyMode";
    private final ForumPrefsManager forumPrefsManager;
    private final ForumManager forumManager;
    private final AnalyticStrategy analyticStrategy;
    private final SpacePermissionManager spacePermissionManager;
    private final SpaceManager spaceManager;
    private final AccessModeService accessModeService;

    public RestForumMacro(@Qualifier(value="licensingSupport") LicensingSupport licensingSupport, MacroServiceAggregator macroServiceAggregator, ForumPrefsManager forumPrefsManager, ForumManager forumManager, AnalyticStrategy analyticStrategy, SpacePermissionManager spacePermissionManager, SpaceManager spaceManager, AccessModeService accessModeService) {
        super(licensingSupport, macroServiceAggregator);
        this.forumManager = forumManager;
        this.forumPrefsManager = forumPrefsManager;
        this.analyticStrategy = analyticStrategy;
        this.spacePermissionManager = spacePermissionManager;
        this.spaceManager = spaceManager;
        this.accessModeService = accessModeService;
    }

    @Override
    public String executeInternal(Map<String, String> parameters, String body, ConversionContext context) {
        parameters.put(BACKGROUND_COLOR, (String)ObjectUtils.defaultIfNull((Object)parameters.get(BACKGROUND_COLOR), (Object)"#4a6785"));
        parameters.put(TEXT_COLOR, (String)ObjectUtils.defaultIfNull((Object)parameters.get(TEXT_COLOR), (Object)"#ffffff"));
        boolean forumSummaryNotification = this.forumManager.getForumSummaryNotification();
        String pageParam = this.getParam(PARAM_PAGE, parameters);
        String templatePageId = this.getParam(PARAM_TEMPLATE_PAGE_ID, parameters);
        String backgroundColorParam = this.getParam(BACKGROUND_COLOR, parameters);
        String textColorParam = this.getParam(TEXT_COLOR, parameters);
        boolean sortStickyOnTop = this.getBooleanParam(PARAM_STICKY_ON_TOP, parameters, this.defaultSortStickyOnTop());
        int pageSize = this.getIntParam(PARAM_PAGE_SIZE, parameters, 20);
        boolean recurse = this.getBooleanParam(PARAM_RECURSE, parameters, false);
        boolean excerpt = this.getBooleanParam(PARAM_EXCERPT, parameters, true);
        PageSpaceParam pageSpaceParam = this.getParamsParser().parsePageSpaceFrom(pageParam, context);
        if (!pageSpaceParam.hasPageAndSpaceKey() && StringUtils.isNotBlank((String)pageParam)) {
            return this.getErrorMessage(context, "com.adaptavist.confluence.restforum.macro.no.such.page", pageParam);
        }
        String validationMessage = this.validatePageAndSpaceParams(context, pageSpaceParam = this.getPageSpaceParam(pageSpaceParam, context));
        if (StringUtils.isNotBlank((String)validationMessage)) {
            return validationMessage;
        }
        this.analyticStrategy.reportEventAnalytics(context, "Forum-Action", "Forum-Viewed");
        return this.resolveTemplate(this.getRenderedTemplateLocation()).withContext(VelocityContextBuilder.contextBuilder().put(PARAM_PAGE_SPACE, pageSpaceParam).put(PARAM_BODY, body).put(PARAM_PREFS, this.forumPrefsManager.getDefaultForumPrefs()).put(PARAM_NEW_TOPIC_LABEL, this.getText("com.adaptavist.confluence.restforum.macro.new.topic.label", new String[0])).put(PARAM_STICKY_ON_TOP, sortStickyOnTop).put(PARAM_PAGE_SIZE, pageSize).put(PARAM_RECURSE, recurse).put(PARAM_EXCERPT, excerpt).put(BACKGROUND_COLOR, backgroundColorParam).put(PARAM_TEMPLATE_PAGE_ID, templatePageId).put(IS_VIEW_MODE_ONLY, this.hasUserReadOnlyPermission(context.getPageContext().getSpaceKey())).put(FORUM_SUMMARY_NOTIFICATION, forumSummaryNotification).put(TEXT_COLOR, textColorParam).put(IS_DC_IN_READ_ONLY_MODE, this.isDcInReadOnlyMode()));
    }

    private boolean isDcInReadOnlyMode() {
        return this.accessModeService.isReadOnlyAccessModeEnabled();
    }

    private boolean hasUserReadOnlyPermission(String spaceKey) {
        return !this.spacePermissionManager.hasPermission("EDITSPACE", this.spaceManager.getSpace(spaceKey), AuthenticatedUserThreadLocal.get());
    }

    private String validatePageAndSpaceParams(ConversionContext context, PageSpaceParam pageSpaceParam) {
        if (!pageSpaceParam.hasPage()) {
            return this.getErrorMessage(context, "com.adaptavist.confluence.restforum.macro.page.required", new String[0]);
        }
        if (!pageSpaceParam.hasSpaceKey()) {
            return this.getErrorMessage(context, "com.adaptavist.confluence.restforum.macro.space.required", new String[0]);
        }
        if (!this.hasViewPermissions(this.getCurrentUser(), pageSpaceParam.getPage())) {
            return this.getErrorMessage(context, "com.adaptavist.confluence.restforum.macro.no.permission", new String[0]);
        }
        return null;
    }

    private PageSpaceParam getPageSpaceParam(PageSpaceParam pageSpaceParam, ConversionContext context) {
        return pageSpaceParam.hasPageAndSpaceKey() ? pageSpaceParam : this.getParamsParser().parsePageSpaceFrom(context);
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    @Override
    protected String getRenderedTemplateLocation() {
        return REST_FORUM_MACRO_TEMPLATE;
    }

    private boolean defaultSortStickyOnTop() {
        return this.forumPrefsManager.getSortPrefs().getStickyOnTop();
    }
}

