/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.beans.search.content;

import com.adaptavist.confluence.forums.view.beans.search.content.ContentSearchCriteria;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ContentSearchCriteriaBuilder {
    private final ContentSearchCriteria.ContentType contentType;
    private String rootPageId;
    private String spaceKey;
    private int startIndex;
    private int pageSize;
    private boolean recursive;
    private Map<String, String> options = new HashMap<String, String>();

    public ContentSearchCriteriaBuilder(ContentSearchCriteria.ContentType contentType, String rootPageId, String spaceKey) {
        this.contentType = contentType;
        this.rootPageId = rootPageId;
        this.spaceKey = spaceKey;
    }

    public ContentSearchCriteriaBuilder(ContentSearchCriteria.ContentType contentType) {
        this.contentType = contentType;
    }

    public static ContentSearchCriteriaBuilder pageTopicContentCriteriaBuilder(long rootPageId) {
        return ContentSearchCriteriaBuilder.pageCriteriaBuilder(ContentSearchCriteria.ContentType.TOPIC, String.valueOf(rootPageId));
    }

    public static ContentSearchCriteriaBuilder pageTopicContentCriteriaBuilder(String rootPageId) {
        return ContentSearchCriteriaBuilder.pageCriteriaBuilder(ContentSearchCriteria.ContentType.TOPIC, rootPageId);
    }

    public static ContentSearchCriteriaBuilder spaceTopicContentCriteriaBuilder(String spaceKey) {
        return ContentSearchCriteriaBuilder.spaceCriteriaBuilder(ContentSearchCriteria.ContentType.TOPIC, spaceKey);
    }

    public static ContentSearchCriteriaBuilder pageForumContentCriteriaBuilder(long rootPageId) {
        return ContentSearchCriteriaBuilder.pageCriteriaBuilder(ContentSearchCriteria.ContentType.FORUM, String.valueOf(rootPageId));
    }

    public static ContentSearchCriteriaBuilder pageForumContentCriteriaBuilder(String rootPageId) {
        return ContentSearchCriteriaBuilder.pageCriteriaBuilder(ContentSearchCriteria.ContentType.FORUM, rootPageId);
    }

    public static ContentSearchCriteriaBuilder spaceForumContentCriteriaBuilder(String spaceKey) {
        return ContentSearchCriteriaBuilder.spaceCriteriaBuilder(ContentSearchCriteria.ContentType.FORUM, spaceKey);
    }

    public static ContentSearchCriteriaBuilder allForumsContentCriteriaBuilder() {
        return new ContentSearchCriteriaBuilder(ContentSearchCriteria.ContentType.FORUM);
    }

    public static ContentSearchCriteriaBuilder pageCriteriaBuilder(ContentSearchCriteria.ContentType contentType, String rootPageId) {
        return new ContentSearchCriteriaBuilder(contentType, rootPageId, null);
    }

    public static ContentSearchCriteriaBuilder spaceCriteriaBuilder(ContentSearchCriteria.ContentType contentType, String spaceKey) {
        return new ContentSearchCriteriaBuilder(contentType, null, spaceKey);
    }

    public ContentSearchCriteriaBuilder startIndex(int startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public ContentSearchCriteriaBuilder pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public ContentSearchCriteriaBuilder recursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public ContentSearchCriteriaBuilder option(String key, String value) {
        if (StringUtils.isNotBlank((String)key) && StringUtils.isNotBlank((String)value)) {
            this.options.put(key, value);
        }
        return this;
    }

    public ContentSearchCriteria build() {
        return new ContentSearchCriteria(this.contentType.name(), this.rootPageId, this.spaceKey, this.startIndex, this.pageSize, this.recursive, this.options);
    }
}

