/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation.impl;

import com.adaptavist.confluence.forums.service.search.SearchKeyIndexResolver;
import com.adaptavist.confluence.forums.service.search.criteria.SearchKeyFinder;
import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.Validator;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchCriteria;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchQueryCriteriaValidator
implements Validator<TopicSearchCriteria> {
    private final SearchKeyFinder searchKeyFinder;
    private final SearchKeyIndexResolver indexResolver;

    @Autowired
    public SearchQueryCriteriaValidator(SearchKeyFinder searchKeyFinder, SearchKeyIndexResolver indexResolver) {
        this.searchKeyFinder = searchKeyFinder;
        this.indexResolver = indexResolver;
    }

    @Override
    public ValidationReport validate(TopicSearchCriteria searchCriteria) {
        String searchText = searchCriteria.getSearchText();
        Set<String> searchKeys = searchCriteria.getSearchKeys();
        if (StringUtils.isBlank((String)searchText) && CollectionUtils.isEmpty(searchKeys)) {
            return ValidationReport.success();
        }
        if (StringUtils.isBlank((String)searchText) || CollectionUtils.isEmpty(searchKeys) || !this.indexResolver.hasIndexes(searchKeys)) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"searchKeys/searchText"});
        }
        Set<String> querySearchKeys = this.searchKeyFinder.findSearchKeys(searchText);
        if (!querySearchKeys.isEmpty() && !this.indexResolver.hasIndexes(querySearchKeys)) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"searchKeys/searchText"});
        }
        return ValidationReport.success();
    }
}

