/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation.impl;

import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.Validator;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.Serializable;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PageIdCriteriaValidator
implements Validator<String> {
    private final PageManager pageManager;

    @Autowired
    public PageIdCriteriaValidator(@ComponentImport PageManager pageManager) {
        this.pageManager = pageManager;
    }

    @Override
    public ValidationReport validate(String pageId) {
        if (!NumberUtils.isDigits((String)pageId)) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"rootPageId"});
        }
        if (this.pageManager.getPage(Long.parseLong(pageId)) == null) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.page.not.found", new Serializable[0]);
        }
        return ValidationReport.success();
    }
}

