/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation.impl;

import com.adaptavist.confluence.forums.model.datatypes.DataTypeManager;
import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.Validator;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataItemsCriteriaValidator
implements Validator<Set<String>> {
    private final DataTypeManager dataTypeManager;

    @Autowired
    public DataItemsCriteriaValidator(DataTypeManager dataTypeManager) {
        this.dataTypeManager = dataTypeManager;
    }

    @Override
    public ValidationReport validate(Set<String> dataItems) {
        if (CollectionUtils.isEmpty(dataItems) || !this.dataTypeManager.hasDataItemTypes(dataItems)) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"dataItemNames"});
        }
        return ValidationReport.success();
    }
}

