/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation;

import com.adaptavist.confluence.forums.service.validation.ValidationFlow;
import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.impl.DataItemsCriteriaValidator;
import com.adaptavist.confluence.forums.service.validation.impl.PageIdCriteriaValidator;
import com.adaptavist.confluence.forums.service.validation.impl.PagePermissionValidator;
import com.adaptavist.confluence.forums.service.validation.impl.SearchFilterCriteriaValidator;
import com.adaptavist.confluence.forums.service.validation.impl.SearchQueryCriteriaValidator;
import com.adaptavist.confluence.forums.service.validation.impl.SearchSortCriteriaValidator;
import com.adaptavist.confluence.forums.service.validation.impl.SpaceKeyCriteriaValidator;
import com.adaptavist.confluence.forums.service.validation.impl.SpacePermissionValidator;
import com.adaptavist.confluence.forums.view.beans.search.content.ContentSearchCriteria;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchCriteria;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ForumSearchValidationManager {
    private final PageIdCriteriaValidator pageIdValidator;
    private final PagePermissionValidator pagePermissionValidator;
    private final SpaceKeyCriteriaValidator spaceKeyValidator;
    private final SpacePermissionValidator spacePermissionValidator;
    private final SearchQueryCriteriaValidator searchQueryValidator;
    private final SearchSortCriteriaValidator searchSortValidator;
    private final SearchFilterCriteriaValidator searchFilterValidator;
    private final DataItemsCriteriaValidator dataItemsValidator;

    @Autowired
    public ForumSearchValidationManager(PageIdCriteriaValidator pageIdValidator, PagePermissionValidator permissionValidator, SpaceKeyCriteriaValidator spaceKeyValidator, SpacePermissionValidator spacePermissionValidator, SearchQueryCriteriaValidator searchQueryValidator, SearchSortCriteriaValidator searchSortValidator, SearchFilterCriteriaValidator searchFilterValidator, DataItemsCriteriaValidator dataItemsValidator) {
        this.pageIdValidator = pageIdValidator;
        this.pagePermissionValidator = permissionValidator;
        this.spaceKeyValidator = spaceKeyValidator;
        this.spacePermissionValidator = spacePermissionValidator;
        this.searchQueryValidator = searchQueryValidator;
        this.searchSortValidator = searchSortValidator;
        this.searchFilterValidator = searchFilterValidator;
        this.dataItemsValidator = dataItemsValidator;
    }

    public ValidationReport validateSearchCriteria(TopicSearchCriteria searchCriteria) {
        if (searchCriteria == null) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"null search criteria"});
        }
        return ValidationFlow.validationFlow().validate(searchCriteria.getForumId()).with(this.pageIdValidator).andThen(searchCriteria.getForumId()).with(this.pagePermissionValidator).andThen(searchCriteria).with(this.searchQueryValidator).andThen(searchCriteria.getSortKey()).with(this.searchSortValidator).andThen(searchCriteria.getFilters()).with(this.searchFilterValidator).andThen(searchCriteria.getDataItemNames()).with(this.dataItemsValidator).andReport();
    }

    public ValidationReport validateSearchCriteria(ContentSearchCriteria searchCriteria) {
        if (searchCriteria == null) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"null search criteria"});
        }
        if (ContentSearchCriteria.SearchScope.PAGE.equals((Object)searchCriteria.getSearchScope())) {
            return ValidationFlow.validationFlow().validate(searchCriteria.getRootPageId()).with(this.pageIdValidator).andThen(searchCriteria.getRootPageId()).with(this.pagePermissionValidator).andReport();
        }
        if (ContentSearchCriteria.SearchScope.SPACE.equals((Object)searchCriteria.getSearchScope())) {
            return ValidationFlow.validationFlow().validate(searchCriteria.getSpaceKey()).with(this.spaceKeyValidator).andThen(searchCriteria.getSpaceKey()).with(this.spacePermissionValidator).andReport();
        }
        return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.space.or.page.required", new Serializable[0]);
    }
}

