/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.sort;

import com.adaptavist.confluence.forums.service.search.sort.ForumSearchSortOptions;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.FieldSort;
import com.atlassian.confluence.search.v2.sort.MultiSearchSort;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public abstract class ForumSearchSort
implements SearchSort {
    private final String key;
    private final SearchSort.Order order;
    private final ForumSearchSortOptions options;

    public ForumSearchSort(String key, SearchSort.Order order, ForumSearchSortOptions options) {
        this.key = key;
        this.order = order;
        this.options = options;
    }

    public String getKey() {
        return this.key;
    }

    public SearchSort.Order getOrder() {
        return this.order;
    }

    public ForumSearchSortOptions getOptions() {
        return this.options;
    }

    protected abstract SearchSort[] getFieldSort();

    public SearchSort expand() {
        Object[] fieldSort = this.getFieldSort();
        if (this.getOptions().isStickyOnTop()) {
            fieldSort = (SearchSort[])ArrayUtils.add((Object[])fieldSort, (int)0, (Object)this.getStickyTopicSort());
        }
        return new MultiSearchSort(Arrays.asList(fieldSort));
    }

    private SearchSort getStickyTopicSort() {
        return new FieldSort("forumIndexPageIsSticky", SearchSort.Type.STRING, SearchSort.Order.DESCENDING);
    }
}

