/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.query;

import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class WatchedTopicsQuery
implements SearchQuery {
    private static final String KEY = "topics-watched-filter-key";
    private final List<String> idsThatUserIsWatching = new ArrayList<String>();

    public WatchedTopicsQuery(NotificationManager notificationManager) {
        List notificationsByUser = notificationManager.getNotificationsByUser((User)AuthenticatedUserThreadLocal.get());
        for (Notification notification : notificationsByUser) {
            if (!notification.isPageNotification()) continue;
            this.idsThatUserIsWatching.add(notification.getContent().getIdAsString());
        }
    }

    public String getKey() {
        return KEY;
    }

    public List<?> getParameters() {
        return this.idsThatUserIsWatching;
    }

    public SearchQuery expand() {
        List should = this.idsThatUserIsWatching.stream().map(id -> new TextFieldQuery("forumIndexPageId", id, BooleanOperator.AND)).collect(Collectors.toList());
        return new BooleanQuery(null, should, null);
    }

    public List<String> getIdsThatUserIsWatching() {
        return this.idsThatUserIsWatching;
    }
}

