/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.impl;

import com.adaptavist.confluence.forums.service.impl.PermissionsSupport;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PagePropertySupport {
    private final ConfluenceIndexer indexer;
    private final PermissionsSupport permissionsSupport;
    private final ContentPropertyManager contentPropertyManager;

    @Autowired
    public PagePropertySupport(@ComponentImport ContentPropertyManager contentPropertyManager, ConfluenceIndexer indexer, PermissionsSupport permissionsSupport) {
        this.contentPropertyManager = contentPropertyManager;
        this.indexer = indexer;
        this.permissionsSupport = permissionsSupport;
    }

    public void addPageProperty(AbstractPage page, String propertyName) {
        if (page != null) {
            this.setContentProperty(page, propertyName, "true");
        }
    }

    public void removePageProperty(AbstractPage page, String propertyName) {
        if (page != null) {
            this.setContentProperty(page, propertyName, null);
        }
    }

    public boolean isPagePropertySet(AbstractPage page, String propertyName) {
        return this.getBooleanProperty(page, propertyName);
    }

    public PermissionsSupport getPermissionsSupport() {
        return this.permissionsSupport;
    }

    public String getSpaceKey(AbstractPage page) {
        return page == null ? null : page.getSpaceKey();
    }

    public List<Page> getDescendants(AbstractPage page) {
        return page instanceof Page ? ((Page)page).getDescendents() : Collections.emptyList();
    }

    public List<Page> getAncestors(AbstractPage page) {
        return page instanceof Page ? ((Page)page).getAncestors() : Collections.emptyList();
    }

    public Boolean getBooleanProperty(AbstractPage page, String key) {
        return Boolean.valueOf(this.getStringProperty(page, key));
    }

    public String getStringProperty(AbstractPage page, String key) {
        return page != null ? this.contentPropertyManager.getStringProperty((ContentEntityObject)page, key) : null;
    }

    public void setStringProperty(AbstractPage page, String key, String value) {
        if (value == null) {
            this.contentPropertyManager.removeProperty((ContentEntityObject)page, key);
        } else {
            this.contentPropertyManager.setStringProperty((ContentEntityObject)page, key, value);
        }
    }

    private void setContentProperty(AbstractPage page, String key, String value) {
        if (value == null) {
            this.contentPropertyManager.removeProperty((ContentEntityObject)page, key);
        } else {
            this.contentPropertyManager.setStringProperty((ContentEntityObject)page, key, value);
        }
        this.indexer.reIndex((Searchable)page);
    }
}

