/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.extractors;

import com.adaptavist.confluence.forums.model.ActivityScore;
import com.adaptavist.confluence.forums.service.ActivityScoreManager;
import com.adaptavist.confluence.forums.service.extractors.AbstractForumExtractor;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.lucene.document.DateTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityScoreForumExtractor
extends AbstractForumExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityScoreForumExtractor.class);
    final ActivityScoreManager activityScoreManager;

    public ActivityScoreForumExtractor(ActivityScoreManager activityScoreManager) {
        this.activityScoreManager = activityScoreManager;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (searchable instanceof Page) {
            Page page = (Page)searchable;
            ActivityScore activityScore = this.activityScoreManager.getActivityScore(page);
            if (activityScore == null) {
                LOGGER.warn("Activity scores will be omitted when building indexes for Forums, because no Forums activity score configuration found in Confluence.");
                LOGGER.warn("This may be an issue as it affects the indexes for Forums. To remediate, try re-enabling the Forums app.");
                return Collections.emptyList();
            }
            builder.add((Object)this.addLongField("forumIndexPageActivityScore", activityScore.getScore()));
            builder.add((Object)this.addStringField("forumIndexPageActivityScoreExpiry", this.getActivityScoreExpiry(activityScore)));
        }
        return builder.build();
    }

    private String getActivityScoreExpiry(ActivityScore activityScore) {
        Long validUntil = activityScore.getExpiryDate();
        if (validUntil != null) {
            Date expiryDate = new Date(validUntil);
            return DateTools.dateToString((Date)expiryDate, (DateTools.Resolution)DateTools.Resolution.MINUTE);
        }
        return null;
    }
}

