/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.extractors;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.Extractor2;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.IntFieldDescriptor;
import com.atlassian.confluence.plugins.index.api.LongFieldDescriptor;
import com.atlassian.confluence.plugins.index.api.StringFieldDescriptor;
import com.atlassian.confluence.plugins.index.api.TextFieldDescriptor;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractForumExtractor
implements Extractor2 {
    public StringBuilder extractText(Object searchable) {
        return new StringBuilder();
    }

    protected Set<String> getParticipants(Page page) {
        HashSet<String> participants = new HashSet<String>();
        this.addParticipant(page.getCreator(), participants);
        for (Comment comment : page.getComments()) {
            this.addParticipant(comment.getCreator(), participants);
        }
        return participants;
    }

    private void addParticipant(ConfluenceUser participant, Set<String> participants) {
        if (participant != null) {
            participants.add(participant.getName());
        }
    }

    String getAuthorFullName(ContentEntityObject entityObject) {
        return entityObject.getCreator() != null ? entityObject.getCreator().getFullName() : null;
    }

    String getAuthorUserName(ContentEntityObject entityObject) {
        return entityObject.getCreator() != null ? entityObject.getCreator().getName() : null;
    }

    protected Long getPageId(Page page) {
        return page == null ? null : Long.valueOf(page.getId());
    }

    String getPageTitle(Page page) {
        return page == null ? null : page.getTitle();
    }

    ContentEntityObject getPageLastActivity(Page page) {
        Page lastActivityObject = page;
        for (Comment comment : page.getComments()) {
            if (comment.getLastModificationDate().getTime() <= lastActivityObject.getLastModificationDate().getTime()) continue;
            lastActivityObject = comment;
        }
        return lastActivityObject;
    }

    public IntFieldDescriptor addIntegerField(String indexField, Integer value) {
        if (value == null) {
            value = 0;
        }
        return new IntFieldDescriptor(indexField, value.intValue(), FieldDescriptor.Store.YES);
    }

    public LongFieldDescriptor addLongField(String indexField, Long value) {
        if (value == null) {
            value = 0L;
        }
        return new LongFieldDescriptor(indexField, value.longValue(), FieldDescriptor.Store.YES);
    }

    public StringFieldDescriptor addStringField(String indexField, String value) {
        if (value == null) {
            value = "";
        }
        return new StringFieldDescriptor(indexField, value, FieldDescriptor.Store.YES);
    }

    public TextFieldDescriptor addTextField(String indexField, String value) {
        if (value == null) {
            value = "";
        }
        return new TextFieldDescriptor(indexField, value, FieldDescriptor.Store.YES);
    }
}

