/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.analytic.event;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAnalyticMetrics {
    private static final String ANONYMOUS_USER = "anonymous-user";
    private static final String CONFLUENCE_ADMIN = "confluence-admin";
    private static final String SPACE_ADMIN = "space-admin";
    private static final String CONFLUENCE_USER = "confluence-user";
    private final PermissionManager permissionManager;
    private final SpacePermissionManager spacePermissionManager;

    @Autowired
    public UserAnalyticMetrics(@ComponentImport PermissionManager permissionManager, @ComponentImport SpacePermissionManager spacePermissionManager) {
        this.permissionManager = permissionManager;
        this.spacePermissionManager = spacePermissionManager;
    }

    public String getUserType(Space space) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return ANONYMOUS_USER;
        }
        if (this.permissionManager.isConfluenceAdministrator(user)) {
            return CONFLUENCE_ADMIN;
        }
        if (this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, user)) {
            return SPACE_ADMIN;
        }
        return CONFLUENCE_USER;
    }

    public String getUserHashCode() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return String.valueOf(user != null ? Integer.valueOf(user.getKey().hashCode()) : "No-Hash-Code");
    }
}

