/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.model.datatypes.values;

import com.adaptavist.confluence.forums.model.datatypes.DataTypeValues;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class DataTypeValuesImpl
implements DataTypeValues {
    private final Map<String, Object> values;

    public DataTypeValuesImpl(Map<String, Object> values) {
        this.values = this.unmodifiable(values);
    }

    @Override
    public Map<String, Object> getValuesAsMap() {
        return this.values;
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public Object getValue(String key) {
        return this.values.get(key);
    }

    @Override
    public String getStringValue(String key) {
        return this.getValue(key, String.class);
    }

    @Override
    public Integer getIntValue(String key) {
        return this.getValue(key, Integer.class);
    }

    @Override
    public Boolean getBooleanValue(String key) {
        return this.getValue(key, Boolean.class);
    }

    @Override
    public Date getDateValue(String key) {
        return this.getValue(key, Date.class);
    }

    @Override
    public <T> T getValue(String key, Class<T> clazz) {
        Object value = this.values.get(key);
        if (value != null && clazz.isAssignableFrom(value.getClass())) {
            return clazz.cast(value);
        }
        return null;
    }

    private Map<String, Object> unmodifiable(Map<String, Object> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(values);
    }
}

