/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.model.datatypes;

import com.adaptavist.confluence.forums.model.datatypes.DataTypeFormatter;
import com.adaptavist.confluence.forums.model.datatypes.PredefinedFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDataTypeFormatter
implements DataTypeFormatter {
    private final String resourceKey = this.getFormatterResourceKey();
    private final PredefinedFormat defaultFormat;
    private final String defaultFormatFullPath;
    private final Map<String, PredefinedFormat> predefinedFormats;

    protected AbstractDataTypeFormatter(PredefinedFormat defaultFormat, PredefinedFormat ... predefinedFormats) {
        this.defaultFormat = defaultFormat;
        this.defaultFormatFullPath = this.getFormatFullPath(defaultFormat.getId());
        this.predefinedFormats = this.toMap(predefinedFormats);
    }

    @Override
    public String getDefaultFormatId() {
        return this.defaultFormat.getId();
    }

    @Override
    public Set<PredefinedFormat> getPredefinedFormats() {
        return new HashSet<PredefinedFormat>(this.predefinedFormats.values());
    }

    @Override
    public boolean hasPredefinedFormat(String formatId) {
        return this.predefinedFormats.containsKey(formatId);
    }

    @Override
    public boolean hasPredefinedFormat(PredefinedFormat format) {
        return format != null && this.predefinedFormats.containsKey(format.getId());
    }

    @Override
    public String getDefaultFormat() {
        return this.defaultFormatFullPath;
    }

    @Override
    public String getFormatFor(String formatId) {
        return formatId == null ? null : this.getFormatFullPath(formatId);
    }

    @Override
    public String getFormatFor(PredefinedFormat format) {
        return format == null ? null : this.getFormatFullPath(format.getId());
    }

    @Override
    public String getResourceKey() {
        return this.resourceKey;
    }

    private String getFormatFullPath(String formatId) {
        return String.format("%s:%s", this.getFormatterName(), formatId);
    }

    private String getFormatterResourceKey() {
        return String.format("%s:%s-resource", "com.adaptavist.confluence.forums", this.getFormatterName());
    }

    private Map<String, PredefinedFormat> toMap(PredefinedFormat ... predefinedFormats) {
        HashMap<String, PredefinedFormat> formatMap = new HashMap<String, PredefinedFormat>(predefinedFormats.length);
        for (PredefinedFormat format : predefinedFormats) {
            formatMap.put(format.getId(), format);
        }
        return formatMap;
    }
}

