/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.rest;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.PageStatusManager;
import com.adaptavist.confluence.forums.service.search.ForumSearchManager;
import com.adaptavist.confluence.forums.service.search.exception.InvalidSearchQueryException;
import com.adaptavist.confluence.forums.service.validation.ForumStatusValidationManager;
import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.view.beans.ForumStatusUpdate;
import com.adaptavist.confluence.forums.view.beans.Status;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchCriteria;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="/pages")
@Produces(value={"application/json"})
public class ForumStatusResource {
    private final PageManager pageManager;
    private final I18nResolver i18nResolver;
    private final PageStatusManager pageStatusManager;
    private final ForumStatusValidationManager validationManager;
    private final ForumSearchManager forumSearchManager;
    private final ForumManager forumManager;

    @Inject
    public ForumStatusResource(PageManager pageManager, PageStatusManager pageStatusManager, @ComponentImport I18nResolver i18nResolver, ForumStatusValidationManager validationManager, ForumSearchManager forumSearchManager, ForumManager forumManager) {
        this.pageManager = pageManager;
        this.i18nResolver = i18nResolver;
        this.pageStatusManager = pageStatusManager;
        this.validationManager = validationManager;
        this.forumSearchManager = forumSearchManager;
        this.forumManager = forumManager;
    }

    @GET
    @Path(value="/{pageId}/sticky")
    public Response getStickyStatus(@PathParam(value="pageId") String pageId) {
        AbstractPage abstractPage = this.getPageById(pageId);
        ValidationReport viewStatusReport = this.validationManager.validateViewPageStatusAction(abstractPage);
        if (viewStatusReport.isSuccess()) {
            return Response.ok((Object)this.pageStatusManager.getStickyStatus(abstractPage)).build();
        }
        return this.validationFailed(viewStatusReport);
    }

    @GET
    @UnrestrictedAccess
    @Path(value="/forumsummary")
    public Response getForumSummary() {
        return Response.ok((Object)this.forumManager.getForumSummaryNotification()).build();
    }

    @POST
    @Path(value="/{pageId}/makeTopic")
    public Response makeTopic(@PathParam(value="pageId") String pageId) {
        this.forumManager.addTopic(this.getPageById(pageId));
        return Response.ok().build();
    }

    @POST
    @Path(value="/{pageId}/markasforum")
    public Response markAsForum(@PathParam(value="pageId") String pageId) {
        this.forumManager.createForum((Page)this.getPageById(pageId));
        return Response.ok().build();
    }

    @POST
    @Path(value="/{pageId}/unmarkChildrenAsTopic")
    public Response unmarkChildrenAsTopic(@PathParam(value="pageId") String pageId) {
        AbstractPage abstractPage = this.getPageById(pageId);
        if (abstractPage == null) {
            return this.invalidSearchResponse("Page with id " + pageId + " not found");
        }
        this.forumManager.unmarkChildrenAsTopic(abstractPage);
        return Response.ok().build();
    }

    @POST
    @Path(value="/{pageId}/sticky/{stickyFlag}")
    public Response updateStickyStatus(@PathParam(value="pageId") String pageId, @PathParam(value="stickyFlag") String stickyFlag) {
        AbstractPage abstractPage = this.getPageById(pageId);
        ValidationReport makeStickyReport = this.validationManager.validateUpdateStickyAction(abstractPage);
        if (makeStickyReport.isSuccess()) {
            this.pageStatusManager.updateStickyStatus(abstractPage, Boolean.parseBoolean(stickyFlag));
            return Response.ok().build();
        }
        return this.validationFailed(makeStickyReport);
    }

    @GET
    @Path(value="/{pageId}/locked")
    public Response getLockedStatus(@PathParam(value="pageId") String pageId) {
        AbstractPage abstractPage = this.getPageById(pageId);
        ValidationReport viewStatusReport = this.validationManager.validateViewPageStatusAction(abstractPage);
        if (viewStatusReport.isSuccess()) {
            return Response.ok((Object)this.pageStatusManager.getLockedStatus(abstractPage)).build();
        }
        return this.validationFailed(viewStatusReport);
    }

    @POST
    @Path(value="/{pageId}/locked/{lockedFlag}")
    public Response updateLockingStatus(@PathParam(value="pageId") String pageId, @PathParam(value="lockedFlag") String lockedFlag) {
        AbstractPage abstractPage = this.getPageById(pageId);
        ValidationReport lockingPageReport = this.validationManager.validateUpdateLockingAction(abstractPage);
        if (lockingPageReport.isSuccess()) {
            this.pageStatusManager.updateLockedStatus(abstractPage, Boolean.parseBoolean(lockedFlag));
            return Response.ok().build();
        }
        return this.validationFailed(lockingPageReport);
    }

    @GET
    @Path(value="/{pageId}/status")
    public Response getStatus(@PathParam(value="pageId") String pageId) {
        AbstractPage abstractPage = this.getPageById(pageId);
        ValidationReport viewStatusReport = this.validationManager.validateViewPageStatusAction(abstractPage);
        if (viewStatusReport.isSuccess()) {
            PageStatusManager.PageStatus pageStatus = this.pageStatusManager.getPageStatus(abstractPage);
            return Response.ok((Object)Status.from(pageStatus)).build();
        }
        return this.validationFailed(viewStatusReport);
    }

    @POST
    @Path(value="/forum/status")
    public Response getForumStatusUpdate(TopicSearchCriteria searchCriteria) {
        try {
            ForumStatusUpdate forumStatusUpdate = this.forumSearchManager.getForumStatusUpdate(searchCriteria);
            return Response.ok((Object)forumStatusUpdate).build();
        }
        catch (InvalidSearchQueryException e) {
            return this.invalidSearchResponse(searchCriteria.toString());
        }
    }

    private Response validationFailed(ValidationReport report) {
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)report.buildResponse(this.i18nResolver)).build();
    }

    private AbstractPage getPageById(String pageId) {
        if (StringUtils.isNumeric((String)pageId)) {
            return this.pageManager.getAbstractPage(Long.parseLong(pageId));
        }
        return null;
    }

    private Response invalidSearchResponse(String messageArgs) {
        return Response.noContent().entity((Object)this.i18nResolver.getText("com.adaptavist.confluence.restforum.resource.invalid.search.query", new Serializable[]{messageArgs})).build();
    }
}

