/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.rest;

import com.adaptavist.confluence.forums.service.PageStatusManager;
import com.adaptavist.confluence.forums.service.search.ForumSearchManager;
import com.adaptavist.confluence.forums.service.search.exception.InvalidSearchQueryException;
import com.adaptavist.confluence.forums.service.validation.ForumSearchValidationManager;
import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.view.beans.RecentForum;
import com.adaptavist.confluence.forums.view.beans.search.content.ContentSearchCriteria;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchCriteria;
import com.adaptavist.confluence.forums.view.beans.search.topics.TopicSearchResults;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.sal.api.message.I18nResolver;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Controller;

@Path(value="/search")
@UnrestrictedAccess
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
public class ForumSearchResource {
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private final PageStatusManager pageStatusManager;
    private final ForumSearchManager forumSearchManager;
    private final ForumSearchValidationManager validationManager;
    private final I18nResolver i18nResolver;

    @Inject
    public ForumSearchResource(ForumSearchManager forumSearchManager, ForumSearchValidationManager validationManager, PageManager pageManager, SpaceManager spaceManager, PageStatusManager pageStatusManager, I18nResolver i18nResolver) {
        this.forumSearchManager = forumSearchManager;
        this.validationManager = validationManager;
        this.i18nResolver = i18nResolver;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.pageStatusManager = pageStatusManager;
    }

    @POST
    @Path(value="/topics")
    @ReadOnlyAccessAllowed
    @JacksonFeatures(serializationDisable={SerializationFeature.FAIL_ON_EMPTY_BEANS})
    public Response searchTopics(TopicSearchCriteria searchCriteria) {
        ValidationReport validationReport = this.validationManager.validateSearchCriteria(searchCriteria);
        if (validationReport.isFailure()) {
            return Response.noContent().entity((Object)validationReport.buildResponse(this.i18nResolver)).build();
        }
        try {
            TopicSearchResults topicSearchResults = this.forumSearchManager.searchTopics(searchCriteria);
            return Response.ok((Object)topicSearchResults).build();
        }
        catch (InvalidSearchQueryException e) {
            return this.invalidSearchResponse(searchCriteria.toString());
        }
    }

    @POST
    @Path(value="/content")
    public Response searchContent(ContentSearchCriteria searchCriteria) {
        ValidationReport criteriaValidation = this.validationManager.validateSearchCriteria(searchCriteria);
        if (criteriaValidation.isFailure()) {
            return Response.noContent().entity((Object)criteriaValidation.buildResponse(this.i18nResolver)).build();
        }
        try {
            if (ContentSearchCriteria.ContentType.FORUM.equals((Object)searchCriteria.getContentType())) {
                return Response.ok((Object)this.forumSearchManager.searchForums(searchCriteria)).build();
            }
            return Response.ok((Object)this.forumSearchManager.searchTopics(searchCriteria)).build();
        }
        catch (InvalidSearchQueryException e) {
            return this.invalidSearchResponse(searchCriteria.toString());
        }
    }

    @GET
    @Path(value="/recentForums")
    public Response recentForums() {
        List<RecentForum> recentForums;
        try {
            recentForums = this.forumSearchManager.getRecentForums();
        }
        catch (InvalidSearchQueryException e) {
            return this.invalidSearchResponse("No Forums");
        }
        return Response.ok(recentForums).build();
    }

    @GET
    @Path(value="/isForumHeaderOn")
    public Response isForumHeaderOn() {
        return Response.ok((Object)this.forumSearchManager.isForumHeaderOn()).build();
    }

    @GET
    @Path(value="/areAllPagesForums/{spaceKey}")
    public Response areAllPagesForums(@PathParam(value="spaceKey") String spaceKey) {
        List abstractPages = this.pageManager.getAbstractPages((Iterable)this.pageManager.getPageIds(this.spaceManager.getSpace(spaceKey)));
        return Response.ok((Object)this.pageStatusManager.areAllPagesForums(abstractPages)).build();
    }

    private Response invalidSearchResponse(String messageArgs) {
        return Response.noContent().entity((Object)this.i18nResolver.getText("com.adaptavist.confluence.restforum.resource.invalid.search.query", new Serializable[]{messageArgs})).build();
    }
}

