/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners.handler.impl.util;

import com.adaptavist.confluence.forums.view.macros.params.PageSpaceParam;
import com.adaptavist.confluence.forums.view.macros.params.ParamsParser;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ForumPagesExtractor {
    private static final String REST_FORUM = "rest-forum";
    private static final String PARAM_PAGE = "page";
    private final ParamsParser paramsParser;

    public ForumPagesExtractor(ParamsParser paramsParser) {
        this.paramsParser = paramsParser;
    }

    public Set<PageSpaceParam> getForumMacroPages(Page sourcePage, List<MacroDefinition> macroDefinitions) {
        return this.getPages(sourcePage, macroDefinitions, REST_FORUM);
    }

    public Set<PageSpaceParam> getForumRootPages(Page sourcePage, List<MacroDefinition> macroDefinitions) {
        return this.getPages(sourcePage, macroDefinitions, PARAM_PAGE);
    }

    private Set<PageSpaceParam> getPages(Page sourcePage, List<MacroDefinition> macroDefinitions, String type) {
        HashSet<PageSpaceParam> pages = new HashSet<PageSpaceParam>();
        for (MacroDefinition macroDefinition : macroDefinitions) {
            PageSpaceParam param = this.paramsParser.parsePageSpaceFrom(sourcePage, macroDefinition.getParameter(type));
            if (!param.hasPageAndSpaceKey()) continue;
            pages.add(param);
        }
        return pages;
    }
}

