/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners;

import com.adaptavist.confluence.converter.json.JsonConverter;
import com.adaptavist.confluence.forums.controller.listeners.ForumsCacheName;
import com.adaptavist.confluence.forums.controller.listeners.ForumsTopicViewsCacheManager;
import com.adaptavist.confluence.forums.service.impl.PagePropertySupport;
import com.atlassian.cache.Cache;
import com.atlassian.confluence.api.model.accessmode.AccessMode;
import com.atlassian.confluence.event.events.cluster.ClusterAccessModeEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.event.api.EventListener;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;

public class ForumsTopicViewsAccessModeEventListener {
    private static final String FORUMS_TOPIC_VIEWS_CACHE = ForumsCacheName.TOPIC_VIEWS.getCacheName();
    private final PagePropertySupport pagePropertySupport;
    private final ForumsTopicViewsCacheManager forumsTopicViewsCacheManager;
    private final PageManager pageManager;
    private final Type type = new TypeToken<Map<String, String>>(){}.getType();

    public ForumsTopicViewsAccessModeEventListener(PagePropertySupport pagePropertySupport, ForumsTopicViewsCacheManager forumsTopicViewsCacheManager, PageManager pageManager) {
        this.pagePropertySupport = pagePropertySupport;
        this.forumsTopicViewsCacheManager = forumsTopicViewsCacheManager;
        this.pageManager = pageManager;
    }

    @EventListener
    public void saveTotalViewsAndClearCache(ClusterAccessModeEvent clusterAccessModeEvent) {
        if (clusterAccessModeEvent.getAccessMode() == AccessMode.READ_ONLY) {
            return;
        }
        this.getCachedViewsPerPageMap().keySet().forEach(abstractPageId -> {
            AbstractPage abstractPage = this.pageManager.getAbstractPage(Long.parseLong(abstractPageId));
            if (abstractPage == null) {
                return;
            }
            this.saveTotalViewsToDatabase(abstractPage);
            this.clearCache(abstractPage);
        });
    }

    private void saveTotalViewsToDatabase(AbstractPage abstractPage) {
        this.pagePropertySupport.setStringProperty(abstractPage, "forumIndexPageNumberOfViews", this.getTotalViews(abstractPage));
    }

    private String getTotalViews(AbstractPage abstractPage) {
        return Integer.toString(this.getSavedViews(abstractPage) + this.getCachedViews(abstractPage));
    }

    private void clearCache(AbstractPage abstractPage) {
        this.forumsTopicViewsCacheManager.clearCachedViews(abstractPage);
    }

    private int getCachedViews(AbstractPage abstractPage) {
        String cachedViews = this.forumsTopicViewsCacheManager.getCachedViews(abstractPage);
        return Integer.parseInt(cachedViews);
    }

    private int getSavedViews(AbstractPage abstractPage) {
        String savedViews = this.pagePropertySupport.getStringProperty(abstractPage, "forumIndexPageNumberOfViews");
        return Integer.parseInt(savedViews);
    }

    private Map<String, String> getCachedViewsPerPageMap() {
        Cache<String, String> cache = this.forumsTopicViewsCacheManager.getCache();
        String jsonCachedMap = (String)cache.get((Object)FORUMS_TOPIC_VIEWS_CACHE);
        return (Map)JsonConverter.fromJson((String)jsonCachedMap, (Type)this.type);
    }
}

