if (typeof Adaptavist == 'undefined') {
    var Adaptavist = {};
}
if (typeof Adaptavist.Forums == 'undefined') {
    Adaptavist.Forums = {};
}
if (typeof Adaptavist.Forums.RestForumMacro == 'undefined') {
    Adaptavist.Forums.RestForumMacro = {};
}
AJS.toInit(function ($) {
    'use strict';

    var defaultPageSize = 20;
    var formatters = {};
    var prefs = {};
    var authorUserName;

    Adaptavist.Forums.RestForumMacro.init = function () {
        var columns = [];
        var datatypes = [];
        var currentForumElement = getJQElement(this),
            paginationElement = currentForumElement.find('.paginate'),
            tableElement = currentForumElement.find('.restforumTable'),
            pageSize = tableElement.data('page-size'),
            includeSubTopics = tableElement.data('recurse'),
            searchComments = false;

        if (isNaN(pageSize) || pageSize <= 0) {
            // If is not a valid page size
            pageSize = defaultPageSize;
        }
        initColsAndDatatypes(currentForumElement, columns, datatypes);

        prefs = {
            $element: currentForumElement,
            $table: tableElement,
            $pagination: paginationElement,
            forumId: currentForumElement.attr('data-target'),
            columns: columns,
            datatypes: datatypes,
            showExcerpt: tableElement.data("showexcerpt"),
            bgStyle: tableElement.attr('style')
        };
        prefs.searchCriteria = {
            forumId: prefs.forumId,
            dataItemNames: prefs.datatypes,
            pageSize: pageSize,
            startIndex: 0,
            includeSubTopics: includeSubTopics,
            searchComments: searchComments
        };

        initComponents(prefs);
        if ($('.error', currentForumElement).length === 0) {
            load(prefs);
        } else {
            var title = AJS.I18n.getText("com.adaptavist.confluence.restforum.columnmacro.error.title");
            error(title, $('.error', currentForumElement).text(), prefs);
        }
        getSummaryNotification()
    };

    function initColsAndDatatypes(currentForumElement, columns, datatypes) {
        $('.column', currentForumElement).each(function () {
            var currentElement = $(this), column = {
                datatype: currentElement.data('type'),
                format: currentElement.data('formatting'),
                heading: currentElement.text()
            };
            columns.push(column);
            datatypes.push(column.datatype);
        });

        // Explicitly add status data type if the column doesn't exist in the forum macro
        // This is needed so we can sort by status (i.e: sticky topic) even when the column is absent
        if (!datatypes.includes("status")) {
            datatypes.push("status");
        }
    }

    //REST call to check if summary notification is selected
    function getSummaryNotification() {
        var data = "";
        jQuery.ajax({
            type: 'GET',
            url: contextPath + '/rest/forums/latest/pages/forumsummary'
        }).always(function (result) {
            data = result;
            if (data) {
                getTopicsSummaryStatus(prefs)
            }
        });
    }

    Adaptavist.Forums.RestForumMacro.registerFormatter = function (name, formatter) {
        formatters[name] = formatter;
    };

    function initButtonShowHide() {
        $('.btnShowHide').click(function () {
            var link = $(this);

            link.next().toggle();

            if ($(this).next().is(':visible')) {
                link.text('Show less');
            } else {
                link.text('Show more');
            }
            return false;
        }).next().hide();
    }

    function initComponents(prefs) {
        var $macro = prefs.$element;
        //Initialize the select2 combobox
        var select2 = $("#select2-filters");
        select2.auiSelect2();


        // Init Date Picker
        $('input[data-date-field]', $macro).each(function () {
            AJS.$(this).datePicker({
                overrideBrowserDefault: true,
                dateFormat: 'yy-mm-dd'

            });
            AJS.$(this).on('change input', function (event) {
                searchTopics(prefs);
            });
        });

        // Check Custom Data Fields
        $('select[data-filter]', $macro).each(function () {
            var value = $(this).val();
            var key = $(this).data('key');

            if (value === 'Custom') {
                $macro.find('div #date-range-' + key).removeClass('forum-date-range-hide');
            } else {
                $macro.find('div #date-range-' + key).addClass('forum-date-range-hide');
            }
        });
    }

    function load(prefs) {
        prefs.$element.on('change', 'select', function (event) {
            Adaptavist.Forums.Commons.PaginationReset(prefs);
            if (this.name.indexOf('forum-filter') === 0) {
                var dateRange = getJQElementById(prefs.$element, 'date-range-' + getJQElement(this).data('key'));
                if (getSelectedOption(this).text() === 'Custom') {
                    dateRange.removeClass('forum-date-range-hide');
                } else {
                    dateRange.addClass('forum-date-range-hide');
                    searchTopics(prefs);
                }
            } else {
                searchTopics(prefs);
            }
        });

        $('#resetSearch', prefs.$element).on('click', function (event) {
            event.preventDefault();
            resetForum(prefs);
            Adaptavist.Forums.Commons.PaginationReset(prefs);
            searchTopics(prefs);
        });

        var select2 = $("#select2-filters");

        select2.on('change', function (event) {
            prefs.searchCriteria['includeUnlockedTopics'] = false;
            prefs.searchCriteria['includeLockedTopics'] = false;
            prefs.searchCriteria['includeWatchedTopics'] = false;
            prefs.searchCriteria['includeHotTopics'] = false;

            select2.select2("data").forEach(function (item) {
                prefs.searchCriteria[item.id] = true;
            });
        });

        //Initially reset the select2 combobox
        select2.select2("val", "");

        var searchingTipsDialog = AJS.InlineDialog(AJS.$("#searching-tips"), "myDialog",
            function (content, trigger, showPopup) {
                content.css({
                    "width": "500px",
                    "padding": "10px 12px"
                }).html(Adaptavist.Forums.RestForumMacro.templates.searchingTips());
                showPopup();

                $('#close-searching-tips', content).on('click', function (event) {
                    searchingTipsDialog.hide();
                });
                return false;
            }
        );
        var delay = (function () {
            var timer = 0;
            return function (callback, ms) {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            };
        })();

        prefs.$element.find('#searchBox').on('input', function (event) {
            delay(function () {
                Adaptavist.Forums.Commons.PaginationReset(prefs);
                searchTopics(prefs);
            }, 500);
        });

        var author = $('#author-topic-filter-input');

        author.on('change', function (event) {
            setTimeout(function () {
                Adaptavist.Forums.Commons.PaginationReset(prefs);
                searchTopics(prefs);
                authorUserName = "";
            }, 100)
        });

        author.bind('selected.autocomplete-user-or-group', function (e, data) {
            authorUserName = data.content.key;  //save username to do lucene search with username instead of fullname where possible later
            $('#author-topic-filter-input').val(data.content.title);
        });

        author.on('keypress', function (event) {
            if (event.keyCode == 13) {
                Adaptavist.Forums.Commons.PaginationReset(prefs);
                searchTopics(prefs);
            }
        });

        prefs.$element.find('#forumSearchForm').on('submit', function (e) {
            e.preventDefault();
        });

        prefs.$element.find('#searchComments').on('click', function (e) {
            Adaptavist.Forums.Commons.PaginationReset(prefs);
            searchTopics(prefs);
        });

        $('input.sticky-checkbox', prefs.$element).on('click', function (e) {
            searchTopics(prefs);
        });
        searchTopics(prefs);
    }

    function resetForum(prefs) {
        clearStickyOnTop(prefs);
        clearSearchBox(prefs);
        clearFilters(prefs);
        clearSorting(prefs);
        clearCommentCheckbox(prefs);
        Adaptavist.Forums.Commons.PaginationReset(prefs);
        searchTopics(prefs);
    }

    function clearSearchBox(prefs) {
        getJQElementById(prefs.$element, 'searchBox').val("");
    }

    function clearCommentCheckbox(prefs) {
        $('#searchComments', prefs.$element).prop('checked', true);
    }

    function clearStickyOnTop(prefs) {
        $('input.sticky-checkbox', prefs.$element).prop('checked', true);
    }

    function clearFilters(prefs) {
        var filters = prefs.$element.find('select[data-filter]');
        for (var i = 0; i < filters.length; i++) {
            clearFilter(prefs, filters[i]);
        }

        var select2 = $("#select2-filters");

        select2.select2("val", "");
        prefs.searchCriteria['includeUnlockedTopics'] = false;
        prefs.searchCriteria['includeLockedTopics'] = false;
        prefs.searchCriteria['includeWatchedTopics'] = false;
        prefs.searchCriteria['includeHotTopics'] = false;
    }

    function clearFilter(prefs, filter) {
        $($(filter).prop("selectedIndex", 0));
        hideDateRangeElement(prefs, filter);
    }

    function hideDateRangeElement(prefs, filter) {
        var dateRange = getJQElementById(prefs.$element, 'date-range-' + getJQElement(filter).data('key'));
        if (!dateRange.hasClass('forum-date-range-hide')) {
            dateRange.addClass('forum-date-range-hide');
        }
    }

    function clearSorting(prefs) {
        var sort = prefs.$element.find('select[data-sort]');
        $($(sort).prop("selectedIndex", 0));
    }

    function render(topicSearchResults, prefs) {
        var searchCriteria = prefs.searchCriteria, paginationBody = '',
            paginationConfig = Adaptavist.Forums.Commons.PaginationGenerate(topicSearchResults.offset, topicSearchResults.total, searchCriteria.pageSize, 3);
        applyFormatters(topicSearchResults, prefs);
        refreshTotalNumberOfTopics(topicSearchResults.total, prefs);
        if (!paginationConfig.isEmpty()) {
            paginationBody = Adaptavist.Forums.Paginate.templates.pagination({config: paginationConfig});
        }
        prefs.$pagination.html(paginationBody);
        prefs.$table.html(Adaptavist.Forums.RestForumMacro.templates.forum({
            forumTopics: topicSearchResults,
            prefs: prefs
        }));
        prefs.$table[0].setAttribute('data-topics', topicSearchResults.total);
        prefs.$table[0].setAttribute('data-topics-on-page', topicSearchResults.topics.length);
        prefs.$table[0].setAttribute('data-index', searchCriteria.startIndex);

        prefs.$pagination.find('li a').on('click', function (e) {
            var newIndex = $(this).data('index');
            if (newIndex == 0) {
                newIndex = 1;
            }
            prefs.searchCriteria.startIndex = (newIndex - 1) * searchCriteria.pageSize;
            searchTopics(prefs);
            e.preventDefault();
        });
        if (topicSearchResults.total == 0 && isReset(prefs)) {
            var title = AJS.I18n.getText("com.adaptavist.confluence.restforum.search.no.topics.found.title");
            var body = AJS.I18n.getText("com.adaptavist.confluence.restforum.search.no.topics.found.body");
            showInfo(title, body, prefs);
        } else {
            $('.restforumMessages', prefs.$element).html("");
        }

        // Show the user's details when we are on the user link
        Confluence.Binder.userHover();
    }

    function refreshTotalNumberOfTopics(number, prefs) {
        showNumberOfTopics(prefs);
        const noOfTopicsText = (number == 1) ? AJS.I18n.getText("com.adaptavist.confluence.restforum.search.oneTopicFound.desc") : AJS.I18n.getText("com.adaptavist.confluence.restforum.search.numberOfTopicsFound.desc", number);
        $('label[for="total-topics-amount"]', prefs.$element).text(noOfTopicsText);
    }

    function isReset(prefs) {
        if (getJQElementById(prefs.$element, 'searchBox').val() != "") {
            return false;
        }
        var filters = prefs.$element.find('select[data-filter]');
        for (var i = 0; i < filters.length; i++) {
            if ($($(filters[i])).prop("selectedIndex") != 0) {
                return false;
            }
        }
        return true;
    }

    function error(title, message, prefs) {
        hideNumberOfTopics(prefs);
        var error = {title: title, body: message};
        $('.restforumMessages', prefs.$element).html(Adaptavist.Forums.RestForumMacro.templates.error({error: error}));
    }

    function showInfo(title, message, prefs) {
        hideNumberOfTopics(prefs);
        var info = {title: title, body: message};
        $('.restforumMessages', prefs.$element).html(Adaptavist.Forums.RestForumMacro.templates.info({info: info}));
    }

    function hideNumberOfTopics(prefs) {
        var numberOfTopicsLabel = $('label[for="total-topics-amount"]', prefs.$element);
        if (!numberOfTopicsLabel.hasClass("hidden")) {
            numberOfTopicsLabel.addClass("hidden");
        }
    }

    function showNumberOfTopics(prefs) {
        var numberOfTopicsLabel = $('label[for="total-topics-amount"]', prefs.$element);
        if (numberOfTopicsLabel.hasClass("hidden")) {
            numberOfTopicsLabel.removeClass("hidden");
        }
    }

    function applyFormatters(topicSearchResults, prefs) {
        var count = topicSearchResults.topics.length;
        while (--count > -1) {
            var topic = topicSearchResults.topics[count];
            topic.viewed = topic.data.viewed.values.viewed; //retrieve topic meta data to pass to soy template
            formatTopic(topic.id, topic, prefs);
        }
    }

    function formatTopic(topicId, topic, prefs) {
        topic.formattedData = [];
        var activityScoreThreshold = getActivityScoreThreshold(prefs);
        for (var i = 0; i < prefs.columns.length; ++i) {
            var column = prefs.columns[i];
            if (formatters[column.format]) {
                var data = topic.data[column.datatype];
                topic.formattedData.push({
                    "column": column.datatype,
                    "content": formatters[column.format](topicId, data, activityScoreThreshold, prefs.showExcerpt, topic.data.viewed.values.viewed, topic.data.createdNew.values.createdNew)
                });
            }
        }
    }

    function getActivityScoreThreshold(prefs) {
        var activityScoreThreshold = $('span[data-activity-threshold]', prefs.$element).data('activity-threshold');
        var threshold = Number(activityScoreThreshold);
        return isNaN(threshold) ? 50 : threshold;
    }

    function searchTopics(prefs) {
        prefs.searchCriteria.searchComments = $('#searchComments').is(':checked');

        prefs.$table.removeClass("loaded").addClass("loading");
        updateSearchCriteriaTextAndSearch(prefs, getJQElementById(prefs.$element, 'searchBox'));
        updateSearchCriteriaWithFiltersAndSort(prefs);
        updateSearchCriteriaWithAuthorFilter(prefs);
        console.log('search json : ' + JSON.stringify(prefs.searchCriteria));
        jQuery.ajax({
            type: 'POST',
            url: contextPath + '/rest/forums/latest/search/topics',
            data: JSON.stringify(prefs.searchCriteria),
            contentType: 'application/json; charset=utf-8',
            dataType: 'json'
        }).done(function (topicSearchResults) {
            render(topicSearchResults, prefs);
            prefs.$table.removeClass("loading").addClass("loaded");
        }).fail(function (response) {
            var title = AJS.I18n.getText("com.adaptavist.confluence.restforum.resource.error.title");
            error(title, response.responseText, prefs);
            prefs.$table.removeClass("loading").addClass("loaded");
        });
    }

    function getTopicsSummaryStatus(prefs) {  //get new and updated topic meta data for aui flag popup
        jQuery.ajax({
            type: 'POST',   //POST instead of GET to comply with browser restrictions on data sent with a GET request
            url: contextPath + '/rest/forums/latest/pages/forum/status/',
            data: JSON.stringify(prefs.searchCriteria),
            contentType: 'application/json; charset=utf-8',
            dataType: 'json'
        }).done(function (json) {
            var callSoyTemplateFlag = Forums.Macro.Flag.statusFlag(json);
            if (json.changedTopics >= 1 || json.newCreatedTopics >= 1) {
                require(['aui/flag'], function (flag) {
                    flag({
                        type: 'info',
                        title: AJS.I18n.getText("com.adaptavist.confluence.resttopicsummary.message.update.status"),
                        close: 'auto',
                        body: callSoyTemplateFlag
                    })
                });
            }
        }).fail(function (json) {
            console.log(AJS.I18n.getText("com.adaptavist.confluence.restforum.resource.error.popup.status"));
        });
    }

    function updateSearchCriteriaTextAndSearch(prefs, searchBox) {
        var searchCriteria = prefs.searchCriteria;
        var searchText = searchBox.val();
        var searchKeys = searchBox.data('search-keys');

        if (hasText(searchText)) {
            searchCriteria.searchText = searchText;
            searchCriteria.searchKeys = searchKeys;
        } else {
            delete searchCriteria.searchText;
            delete searchCriteria.searchKeys;
        }
    }

    function updateSearchCriteriaWithFiltersAndSort(prefs) {
        var searchCriteria = prefs.searchCriteria;
        var filters = prefs.$element.find('select[data-filter]');
        var sort = prefs.$element.find('select[data-sort]');
        searchCriteria.activityIndicatorThreshold = getActivityScoreThreshold(prefs);

        addFiltersToSearchCriteria(searchCriteria, filters, prefs);
        addSortToSearchCriteria(searchCriteria, sort);
    }

    function updateSearchCriteriaWithAuthorFilter(prefs) {
        var searchCriteria = prefs.searchCriteria;
        var authorName = prefs.$element.find('input[author-filter]');
        var filter = {key: 'createdby', values: [], valueType: 'simple'};

        if ((authorUserName !== undefined) && (authorUserName !== "")) { //use author prediction value selected by user
            var authorNameVal = authorUserName;

            if ((authorNameVal !== undefined) && (authorNameVal !== "")) {
                filter.values = [authorNameVal];
                searchCriteria.filters.push(filter);
            }
        } else {                                                         //else use author input field value
            var firstNameVal = authorName.val().toLowerCase();
            authorNameVal = capitalizeFirstLetter(firstNameVal);

            if ((authorNameVal !== undefined) && (authorNameVal !== "")) {
                filter.values = [authorNameVal];
                searchCriteria.filters.push(filter);
            }
        }
    }

    function addFiltersToSearchCriteria(searchCriteria, filters, prefs) {
        searchCriteria.filters = [];
        for (var i = 0; i < filters.length; i++) {
            var filterOption = getSelectedOption(filters[i]);
            var filterVal = filterOption.data('filter-value');
            var filter = {key: filterOption.data('filter-key'), values: [], valueType: 'simple'};
            if (filterOption.text() === 'Custom') {
                var startDate = getDateFrom('from-date-' + filter.key, prefs, 'yymmdd');
                var endDate = getDateFrom('to-date-' + filter.key, prefs, 'yymmdd');
                if (hasText(startDate) && hasText(endDate)) {
                    filter.values = [startDate, endDate];
                    filter.valueType = 'range';
                    searchCriteria.filters.push(filter);
                }
            } else if (hasText(filterVal)) {
                filter.values = [filterVal];
                searchCriteria.filters.push(filter);
            }
        }
    }

    function addSortToSearchCriteria(searchCriteria, sort) {
        var sortOption = getSelectedOption(sort);
        searchCriteria.sortKey = sortOption.data('sort-key');
        searchCriteria.sortOrder = sortOption.data('sort-order');
        searchCriteria.sortStickyOnTop = $('input.sticky-checkbox', prefs.$element).is(':checked');
    }

    function getSelectedOption(select) {
        return $($(select).find('option:selected'));
    }

    function getJQElementById(elem, id) {
        return $(elem).find('#' + id);
    }

    function getJQElement(elem) {
        return $(elem);
    }

    function hasText(string) {
        return string != undefined && $.trim(string.toString()).length > 0;
    }

    function getDateFrom(datePickerId, prefs, format) {
        return getJQElementById(prefs.$element, datePickerId).val().split('-').join('');
    }

    function capitalizeFirstLetter(authorName) {
        var pieces = authorName.split(" ");

        for (var i = 0; i < pieces.length; i++) {
            var eachPiece = pieces[i].charAt(0).toUpperCase();
            pieces[i] = eachPiece + pieces[i].substr(1);
        }
        return pieces.join(" ")
    }

    /**
     * Function to set the local storage
     * @param item
     */
    function setStorageItem(item) {
        if (typeof(Storage) !== "undefined") {
            localStorage.setItem(item, "true");
        }
    }

    /**
     * Get local storage value for a given key
     * @param item
     */
    function getStorageItem(item) {
        if (typeof(Storage) !== "undefined") {
            return localStorage.getItem(item);
        }
    }

    function initPdfWarningDialog() {
        AJS.InlineDialog(
            $('#action-export-pdf-link'),
            'pdfLink',
            function (content, trigger, showPopup) {
                content
                    .css(
                        {
                            padding: '20px'
                        })
                    .html(
                        '<h2>Please note</h2>' +
                        '<p>Unfortunately, it\'s not currently possible to export a page containing Forums to a pdf using Confluence\'s built in pdf exporter.</p>' +
                        '<p>To get a pdf file of this page, please use your browsers built in "<a target="_blank" href="http://www.adaptavist.com/doco/display/CFP2/Community+Forums+Plugin+2.0#CommunityForumsPlugin2.0-KnownIssuesKnownIssues">Save as pdf</a>" functionality.</p>' +
                        '<p><a target="_blank" href="http://www.adaptavist.com/doco/display/CFP2/Community+Forums+Plugin+2.0">Read more</a></p>'
                    );
                showPopup();
                return false;
            }
        );
    }

    $('.restforum').each(Adaptavist.Forums.RestForumMacro.init);

    initButtonShowHide();

    initPdfWarningDialog();
});


//Polyfill to make old browsers work with Confluence
if (AJS.$.browser.mozilla && AJS.$.browser.version === "17.0") {
    window.requestAnimationFrame = function () {

    };
}
