AJS.bind("init.rte", function () {
    var updateMacro = function (macroName, macroNode, param) {
        var $macroDiv = AJS.$(macroNode);
        AJS.Rte.getEditor().selection.select($macroDiv[0]);
        AJS.Rte.BookmarkManager.storeBookmark();

        var macroRenderRequest = {
            contentId: Confluence.Editor.getContentId(),
            macro: {
                name: macroName,
                params: {"format": param},
                defaultParameterValue: "",
                body: ""
            }
        };

        tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest);
    };

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("title-link", function (e, macroNode) {
        updateMacro("rest-forum-column-title", macroNode, "link");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("title-plaintext", function (e, macroNode) {
        updateMacro("rest-forum-column-title", macroNode, "plaintext");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("creation-date-friendly", function (e, macroNode) {
        updateMacro("rest-forum-column-creationdate", macroNode, "friendly");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("creation-date-confluence-date", function (e, macroNode) {
        updateMacro("rest-forum-column-creationdate", macroNode, "confluence-date");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("creation-date-local-date", function (e, macroNode) {
        updateMacro("rest-forum-column-creationdate", macroNode, "local-date");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("last-activity-date-friendly", function (e, macroNode) {
        updateMacro("rest-forum-column-lastactivitydate", macroNode, "friendly");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("last-activity-date-confluence-date", function (e, macroNode) {
        updateMacro("rest-forum-column-lastactivitydate", macroNode, "confluence-date");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("last-activity-date-local-date", function (e, macroNode) {
        updateMacro("rest-forum-column-lastactivitydate", macroNode, "local-date");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("created-by-link", function (e, macroNode) {
        updateMacro("rest-forum-column-createdby", macroNode, "link");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("created-by-plaintext", function (e, macroNode) {
        updateMacro("rest-forum-column-createdby", macroNode, "plaintext");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("created-by-userpicture", function (e, macroNode) {
        updateMacro("rest-forum-column-createdby", macroNode, "userpicture");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("activity-score-plaintext", function (e, macroNode) {
        updateMacro("rest-forum-column-activityscore", macroNode, "plaintext");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("replies-plaintext", function (e, macroNode) {
        updateMacro("rest-forum-column-replies", macroNode, "plaintext");
    });

    AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("status-image", function (e, macroNode) {
        updateMacro("rest-forum-column-status", macroNode, "image");
    });
});