AJS.toInit(function () {
    'use strict';

    /**
     * Creates a Discovery dialog if it hasn't been acknowledged before
     * @param idToPointTo - id where to point the dialog
     * @param title - the title of the dialog
     * @param body - the body text
     * @param dialogName - what to save
     * @param additionalOptions - for the inline dialog
     */
    Forums.Macros.Discovery.create = function (idToPointTo, body, dialogName, additionalOptions, title) {
        var jqueryVar = $('#' + idToPointTo);

        if (jqueryVar.length) {
            var idOfDialog = idToPointTo + '-dialog';
            if (typeof(title) === "undefined") {
                title = AJS.I18n.getText("com.adaptavist.confluence.restforum.macro.new.feature.popup.heading");
            }

            var settings = {hideDelay: null, persistent: true};

            if (typeof(additionalOptions) !== "undefined") {
                $.extend(settings, additionalOptions);
            }

            //get user preference
            var showDiscoveryDialog = false;
            $.ajax({
                type: 'GET',
                async: false,
                url: AJS.params.baseUrl + '/rest/forums/latest/discovery/' + dialogName,
                dataType: 'json',
                timeout: 500
            }).success(function (data) {
                showDiscoveryDialog = data;
            }).fail(function () {
                showDiscoveryDialog = false; //if the call fails for some reason we don't show the dialog
            });

            if (showDiscoveryDialog || showDiscoveryDialog === null) {
                var popup = AJS.InlineDialog(
                    jqueryVar,
                    idOfDialog,
                    function (content, trigger, showPopup) {
                        content
                            .html(Forums.Macros.Discovery.content({
                                title: title,
                                body: body,
                                idOfDialog: idOfDialog,
                                dialogName: dialogName
                            }));
                        showPopup();
                        return false;
                    },
                    settings
                );
                popup.show();
            }
        }
    };

    /**
     * Set the users preference once the discovery dialog is dismissed
     * @param element - The specific dialog clicked
     */
    Forums.Macros.Discovery.onClick = function (element) {
        var idOfDialog = element.getAttribute("idOfDialog");
        var dialogName = element.getAttribute("dialogName");

        //set user preference
        $.ajax({
            type: 'POST',
            url: AJS.params.baseUrl + '/rest/forums/latest/discovery/' + dialogName + '/false',
            beforeSend: function (request) {
                request.setRequestHeader("X-Atlassian-token", "no-check");
            }
        }).success(function () {
            console.log('Forums discovery dialog dismissed preference saved for ' + dialogName)
        }).fail(function () {
            console.error('Forums discovery dialog dismissed preference not saved for ' + dialogName);
        });

        AJS.$('#inline-dialog-' + idOfDialog).remove();
    };

    //using same 'disablepopups' key as forms so that user does not have to apply multiple keys for different macros
    if (AJS.Meta.get('access-mode') !== 'READ_ONLY' && AJS.params.remoteUser !== '' && AJS.DarkFeatures.getAllEnabled().indexOf("com.adaptavist.confluence.forms.disablepopups") === -1) {
        Forums.Macros.Discovery.create('forums-link', AJS.I18n.getText("com.adaptavist.confluence.restforum.macro.new.feature.popup.palette.tooltip"), "new-header-seen");
        Forums.Macros.Discovery.create('newFeaturePopup',
            AJS.I18n.getText("com.adaptavist.confluence.restforum.macro.new.feature.popup.palette.tooltip"), "forum-palette-seen");
    }
});