if (Adaptavist === undefined) {
    var Adaptavist = {};
}
if (Adaptavist.Forums === undefined) {
    Adaptavist.Forums = {};
}
if (Adaptavist.Forums.Commons === undefined) {
    Adaptavist.Forums.Commons = {};
}

AJS.toInit(function ($) {
    /**
     *
     * @param {type} currentIndex Current index of the page
     * @param {type} totalSize Total elements of the search query
     * @param {type} pageSize  Size of the page
     * @param {type} hideBeforeNum  Hide element before current one if they are more than this value
     * @param {type} hideAfterNum   Hide element after current one if they are more than this value
     * @returns {_L5.generatePagination.Anonym$1}
     *
     * This function should be handled as a JQuery component (This component should be standalone and used in another plugins)
     * The pagination in the soy template should be outside of restforum.soy
     * Add "..." element as specified in hideBeforeNum and hideAfterNum
     *
     */


    Adaptavist.Forums.Commons.PaginationGenerate = function (currentIndex, totalSize, pageSize, hideAfterNum) {
        var currentLocalIndex = Math.floor(currentIndex / pageSize) + 1;
        if (currentLocalIndex == 0) {
            currentLocalIndex = 1;
        }
        var prevPages = [], nextPages = [], nextIndex, isReallyNeeded;
        var lastPage = Math.ceil(totalSize / pageSize);

        for (var i = 0; i < currentLocalIndex - 1; ++i) {
            prevPages[i] = i + 1;
        }
        if (currentLocalIndex < lastPage) {
            for (var i = currentLocalIndex; i < lastPage; ++i) {
                nextPages[i - currentLocalIndex] = i + 1;
            }
            nextIndex = currentLocalIndex + 1;
        }
        else {
            nextIndex = currentLocalIndex;
        }

        isReallyNeeded = function () {
            return (prevPages.length === nextPages.length && prevPages.length === 0);
        };

        return {
            currentIndex: currentLocalIndex,
            prevIndexes: prevPages,
            nextIndexes: nextPages,
            prevIndex: currentLocalIndex - 1,
            nextIndex: nextIndex,
            lastIndex: lastPage,
            hideAfterNum: hideAfterNum,
            isEmpty: isReallyNeeded
        };
    };
    Adaptavist.Forums.Commons.PaginationReset = function (prefs) {
        prefs.searchCriteria.startIndex = 0;
    };
});
