AJS.toInit(function ($) {
    var pageDoesNotExistErrorText = AJS.I18n.getText("forum.blueprint.wizard.forumConfigurationPage.rootPage.required");
    var pageAlreadyExistsErrorText = AJS.I18n.getText("forum.blueprint.wizard.forumConfigurationPage.page.exists");
    var maximumAllowedPageSize = 100;
    var minimumAllowedPageSize = 1;
    $(document).on('change', '#blueprint-forums-page-title', function (e, state) {
        $('#forumTitleError').html('');
    });
    $(document).on('change', '#rootPage', function (e, state) {
        $('#rootPageError').html('');
    });
    $(document).on('change', '#threshold', function (e, state) {
        $('#thresholdError').html('');
    });
    $(document).on('change', '#noOfTopics', function (e, state) {
        $('#noOfTopicsError').html('');
    });
    function isNumeric(n) {
        return !isNaN(parseFloat(n)) && isFinite(n);
    }

    function validateRequiredField($container, fieldId, error) {
        var $field = $container.find(fieldId);
        if ($.trim($field.val()) == "") {
            $field.focus().siblings(".error").html(error);
            return false;
        }
        return true;
    }

    function handleRootPageDoesNotExist($pageTitle, error) {
        $pageTitle.focus().siblings(".error").html(error);
    }

    function pageExists(json, $pageTitle) {
        if (json.group.length == 0) { //group contains the group of pages returned by the search
            return false;
        }
        if (json.group.length > 0) {
            var pagesGroup = json.group[0];

            if (pagesGroup.result == 0) {
                return false;
            }
            return pagesGroup.result[0].title.toLowerCase() == $pageTitle.val().toLowerCase();

        }
        return false;
    }

    function getLiveSearchPages($pageTitle, spaceKey) {
        var liveSearchPages;
        $.ajax({
            type: 'GET',
            async: false,
            url: Confluence.getContextPath() + AJS.REST.getBaseUrl() + "search.json",
            data: {
                spaceKey: spaceKey,
                query: $pageTitle.val(),
                type: "page",
                search: "name",
                pageSize: 1
            },
            dataType: 'json'
        }).done(function (json) {
            liveSearchPages = json;

        }).fail(function (json) {
            }
        );
        return liveSearchPages;
    }


    function validateNumberRequired($container, fieldId, error) {
        var $field = $container.find(fieldId);
        if ($.trim($field.val()) == "") {
            $field.focus().siblings(".error").html(error);
            return false;
        }
        if (!isNumeric($.trim($field.val()))) {
            $field.focus().siblings(".error").html(error);
            return false;
        }
        return true;
    }

    function validateNoOfTopics($container, fieldId) {

        if (!validateNumberRequired($container, fieldId, AJS.I18n.getText("forum.blueprint.wizard.advancedConfiguration.topicsPerPage.required.text"))) {
            return false;
        }

        return validateIsInRange($container, fieldId, AJS.I18n.getText("forum.blueprint.wizard.advancedConfiguration.topicsPerPage.maxAllowed.text"));
    }

    function validateIsInRange($container, fieldId, error) {
        var $field = $container.find(fieldId);
        var noOfTopics = Number($.trim($field.val()));
        if (noOfTopics > maximumAllowedPageSize || noOfTopics < minimumAllowedPageSize) {
            $field.focus().siblings(".error").html(error);
            return false;
        }
        return true;
    }

    function handleForumTitleIsInvalid($pageTitle, pageAlreadyExistsErrorText) {
        $pageTitle.focus().siblings(".error").html(pageAlreadyExistsErrorText);
    }

    function choosePathSubmit(e, state) {
        var success = true;
        var titleValid = validateRequiredField(state.$container, "#blueprint-forums-page-title", AJS.I18n.getText("forum.blueprint.wizard.forumConfigurationPage.title.required.text"));
        if (!titleValid) {
            success = false;
        }

        var configurationOption = state.pageData.configurationOption;
        if (configurationOption == "default") {
            state.nextPageId = "setupCompletePage";
        } else {
            state.nextPageId = "informationDisplayedPage";
        }
        var $titleField = state.$container.find("#blueprint-forums-page-title");
        var liveSearchPages = getLiveSearchPages($titleField, state.wizardData.spaceKey);
        if (!liveSearchPages || (liveSearchPages && pageExists(liveSearchPages, $titleField))) {
            handleForumTitleIsInvalid($titleField, pageAlreadyExistsErrorText);
            success = false;
        }
        return success;
    }

    function handleInformationDisplay(e, state) {
        state.nextPageId = "activityScorePage";
    }

    function handleAdvancedConfiguration(e, state) {
        var success = true;
        var $pageField = state.$container.find("#rootPage");
        if (!$.trim($pageField.val()) == "") {
            var liveSearchPages = getLiveSearchPages($pageField);
            if (!liveSearchPages || (liveSearchPages && !pageExists(liveSearchPages, $pageField))) {
                handleRootPageDoesNotExist($pageField, pageDoesNotExistErrorText);
                success = false;
            }
        }

        var topicsPerPage = validateNoOfTopics(state.$container, "#noOfTopics");
        if (!topicsPerPage) {
            success = false;
        }
        if (!success) {
            return false;
        }
        state.nextPageId = "setupCompletePage";
    }

    function handleActivityScore(e, state) {
        var threshold = validateNumberRequired(state.$container, "#threshold", AJS.I18n.getText("forum.blueprint.wizard.forumConfigurationPage.threshold.required.text"));
        if (!threshold) {
            return false;
        }
        state.nextPageId = "advancedConfigurationPage";

    }

    function handlesetupComplete(e, state) {
    }

    Confluence.Blueprint.setWizard('com.adaptavist.confluence.forums:create-forum-template', function (wizard) {
        wizard.on("submit.forumConfigurationPage", choosePathSubmit);
        wizard.on("submit.informationDisplayedPage", handleInformationDisplay);
        wizard.on("submit.advancedConfigurationPage", handleAdvancedConfiguration);
        wizard.on("submit.activityScorePage", handleActivityScore);
        wizard.on("submit.setupCompletePage", handlesetupComplete);
        wizard.on('post-render.advancedConfigurationPage', function (e, state) {
            AJS.Confluence.Binder.autocompletePage();
        });
    });
});