/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.view.beans.search.content;

import com.adaptavist.confluence.forums.view.beans.search.Pagination;
import com.adaptavist.confluence.forums.view.beans.search.SearchCriteria;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ContentSearchCriteria
extends SearchCriteria
implements Pagination {
    public final SearchScope searchScope;
    public final ContentType contentType;
    public final String rootPageId;
    public final String spaceKey;
    public final int startIndex;
    public final int pageSize;
    public final boolean recursive;
    public final Map<String, String> options;

    @JsonCreator
    public ContentSearchCriteria(@JsonProperty(value="contentType") String contentType, @JsonProperty(value="rootPageId") String rootPageId, @JsonProperty(value="spaceKey") String spaceKey, @JsonProperty(value="startIndex") int startIndex, @JsonProperty(value="pageSize") int pageSize, @JsonProperty(value="recursive") boolean recursive, @JsonProperty(value="options") Map<String, String> options) {
        this.options = this.defaultIfNull(options, Collections.emptyMap());
        this.searchScope = ContentSearchCriteria.getScopeType(rootPageId, spaceKey);
        this.contentType = ContentType.fromString(contentType);
        this.rootPageId = rootPageId;
        this.spaceKey = spaceKey;
        this.startIndex = startIndex;
        this.pageSize = pageSize;
        this.recursive = recursive;
    }

    private static SearchScope getScopeType(String rootPageId, String spaceKey) {
        if (StringUtils.isBlank((String)rootPageId) && StringUtils.isNotBlank((String)spaceKey)) {
            return SearchScope.SPACE;
        }
        return StringUtils.isNotBlank((String)rootPageId) ? SearchScope.PAGE : SearchScope.UNKNOWN;
    }

    @JsonProperty(value="contentType")
    public ContentType getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="rootPageId")
    public String getRootPageId() {
        return this.rootPageId;
    }

    @JsonProperty(value="spaceKey")
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Override
    @JsonProperty(value="startIndex")
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    @JsonProperty(value="pageSize")
    public int getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="recursive")
    public boolean isRecursive() {
        return this.recursive;
    }

    @JsonProperty(value="options")
    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @JsonIgnore
    public SearchScope getSearchScope() {
        return this.searchScope;
    }

    @JsonIgnore
    public String toString() {
        return "ContentSearchCriteria{detected-searchScope=" + this.searchScope + ", contentType='" + this.contentType + "', rootPageId='" + this.rootPageId + "', spaceKey='" + this.spaceKey + "', startIndex=" + this.startIndex + ", pageSize=" + this.pageSize + ", recursive=" + this.recursive + ", options=" + this.options + "}";
    }

    public static enum SearchScope {
        PAGE,
        SPACE,
        UNKNOWN;

    }

    public static enum ContentType {
        TOPIC,
        FORUM;


        public static ContentType fromString(String searchType) {
            return FORUM.name().equalsIgnoreCase(searchType) ? FORUM : TOPIC;
        }
    }
}

