/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation.impl;

import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.Validator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class SearchSortCriteriaValidator
implements Validator<String> {
    public static final Set<String> ALLOWED_SORT_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("title", "creationdate", "createdby", "status", "lastactivitydate", "replies", "views", "activityscore", "lastcommentby")));

    @Override
    public ValidationReport validate(String sortKey) {
        if (StringUtils.isNotBlank((String)sortKey) && !ALLOWED_SORT_KEYS.contains(sortKey)) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.invalid.search.criteria", new Serializable[]{"sortKey"});
        }
        return ValidationReport.success();
    }
}

