/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation.impl;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.StickyPageManager;
import com.adaptavist.confluence.forums.service.validation.ValidationReport;
import com.adaptavist.confluence.forums.service.validation.Validator;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MakeStickyPageValidator
implements Validator<AbstractPage> {
    private final ForumManager forumManager;
    private final StickyPageManager stickyPageManager;

    @Autowired
    public MakeStickyPageValidator(ForumManager forumManager, StickyPageManager stickyPageManager) {
        this.forumManager = forumManager;
        this.stickyPageManager = stickyPageManager;
    }

    @Override
    public ValidationReport validate(AbstractPage page) {
        if (page == null) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.page.not.found", new Serializable[0]);
        }
        if (!this.forumManager.isTopic(page)) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.resource.pages.not.topic", new Serializable[0]);
        }
        if (!this.stickyPageManager.hasUpdateStickyPermission((User)AuthenticatedUserThreadLocal.get(), page)) {
            return ValidationReport.failure().withReason("com.adaptavist.confluence.restforum.action.sticky.no.permission", new Serializable[0]);
        }
        return ValidationReport.success();
    }
}

