/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.sort.impl;

import com.adaptavist.confluence.forums.model.module.impl.SearchSorterModuleDescriptor;
import com.adaptavist.confluence.forums.service.search.sort.ForumSearchSort;
import com.adaptavist.confluence.forums.service.search.sort.ForumSearchSortManager;
import com.adaptavist.confluence.forums.service.search.sort.ForumSearchSortOptions;
import com.adaptavist.confluence.forums.service.search.sort.fields.ActivityScoreForumSort;
import com.adaptavist.confluence.forums.service.search.sort.fields.CreatedByForumSort;
import com.adaptavist.confluence.forums.service.search.sort.fields.CreationDateForumSort;
import com.adaptavist.confluence.forums.service.search.sort.fields.LastActivityDateForumSort;
import com.adaptavist.confluence.forums.service.search.sort.fields.LastCommentByForumSort;
import com.adaptavist.confluence.forums.service.search.sort.fields.NumberOfRepliesForumSort;
import com.adaptavist.confluence.forums.service.search.sort.fields.NumberOfViewsForumSort;
import com.adaptavist.confluence.forums.service.search.sort.fields.PageTitleForumSort;
import com.adaptavist.confluence.forums.service.search.sort.fields.StatusPageForumSort;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class DefaultForumSearchSortManager
implements ForumSearchSortManager {
    private final PluginAccessor pluginAccessor;
    private Set<String> sorterKeys;

    public DefaultForumSearchSortManager(@ComponentImport PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public static String getKey(String key, SearchSort.Order order) {
        return key + "-" + order.name();
    }

    @Override
    public void flushCaches() {
        this.sorterKeys = null;
    }

    private void loadKeys() {
        if (this.sorterKeys == null) {
            this.sorterKeys = new HashSet<String>();
            List modules = this.pluginAccessor.getEnabledModuleDescriptorsByClass(SearchSorterModuleDescriptor.class);
            for (SearchSorterModuleDescriptor module : modules) {
                this.sorterKeys.addAll(module.getSorterKeys());
            }
        }
    }

    @Override
    public ForumSearchSort getForumSorter(String key, SearchSort.Order order) {
        this.loadKeys();
        return this.get(key, order, ForumSearchSortOptions.DEFAULT_OPTIONS);
    }

    @Override
    public ForumSearchSort getForumSorter(String key, SearchSort.Order order, ForumSearchSortOptions sortOptions) {
        this.loadKeys();
        return this.get(key, order, sortOptions);
    }

    private boolean isKeyValid(String key, SearchSort.Order order) {
        return key != null && order != null;
    }

    private ForumSearchSort get(String key, SearchSort.Order order, ForumSearchSortOptions sortOptions) {
        if (this.keyExists(key, order)) {
            switch (key) {
                case "forum-sort-activityscore": {
                    return new ActivityScoreForumSort(key, order, sortOptions == null ? ForumSearchSortOptions.DEFAULT_OPTIONS : sortOptions);
                }
                case "forum-sort-createdby": {
                    return new CreatedByForumSort(key, order, sortOptions == null ? ForumSearchSortOptions.DEFAULT_OPTIONS : sortOptions);
                }
                case "forum-sort-creationdate": {
                    return new CreationDateForumSort(key, order, sortOptions == null ? ForumSearchSortOptions.DEFAULT_OPTIONS : sortOptions);
                }
                case "forum-sort-lastactivitydate": {
                    return new LastActivityDateForumSort(key, order, sortOptions == null ? ForumSearchSortOptions.DEFAULT_OPTIONS : sortOptions);
                }
                case "forum-sort-replies": {
                    return new NumberOfRepliesForumSort(key, order, sortOptions == null ? ForumSearchSortOptions.DEFAULT_OPTIONS : sortOptions);
                }
                case "forum-sort-views": {
                    return new NumberOfViewsForumSort(key, order, sortOptions == null ? ForumSearchSortOptions.DEFAULT_OPTIONS : sortOptions);
                }
                case "forum-sort-lastcommentby": {
                    return new LastCommentByForumSort(key, order, sortOptions == null ? ForumSearchSortOptions.DEFAULT_OPTIONS : sortOptions);
                }
                case "forum-sort-title": {
                    return new PageTitleForumSort(key, order, sortOptions == null ? ForumSearchSortOptions.DEFAULT_OPTIONS : sortOptions);
                }
                case "forum-sort-status": {
                    return new StatusPageForumSort(key, order, sortOptions == null ? ForumSearchSortOptions.DEFAULT_OPTIONS : sortOptions);
                }
            }
        }
        return null;
    }

    private boolean keyExists(String key, SearchSort.Order order) {
        return this.isKeyValid(key, order) && this.sorterKeys.contains(DefaultForumSearchSortManager.getKey(key, order));
    }
}

