/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.results.impl;

import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessor;
import com.adaptavist.confluence.forums.service.search.results.SearchResultAccessors;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultSearchResultAccessors
implements SearchResultAccessors {
    public static final SearchResultAccessors EMPTY_RESULT_ACCESSORS = new DefaultSearchResultAccessors();
    private final int unfilteredResultsCount;
    private List<SearchResultAccessor> resultAccessors;

    private DefaultSearchResultAccessors() {
        this.unfilteredResultsCount = 0;
        this.resultAccessors = Collections.emptyList();
    }

    public DefaultSearchResultAccessors(List<SearchResultAccessor> searchResultAccessors, int unfilteredResultsCount) {
        this.unfilteredResultsCount = unfilteredResultsCount;
        this.resultAccessors = this.immutableResultAccessors(searchResultAccessors);
    }

    @Override
    public int getUnfilteredResultsCount() {
        return this.unfilteredResultsCount;
    }

    @Override
    public int size() {
        return this.resultAccessors.size();
    }

    @Override
    public SearchResultAccessor getFirst() {
        return this.resultAccessors.size() > 0 ? this.resultAccessors.get(0) : null;
    }

    @Override
    public Iterator<SearchResultAccessor> iterator() {
        return this.resultAccessors.iterator();
    }

    @Override
    public List<SearchResultAccessor> getAll() {
        return this.resultAccessors;
    }

    private List<SearchResultAccessor> immutableResultAccessors(List<SearchResultAccessor> searchResultAccessors) {
        if (searchResultAccessors == null || searchResultAccessors.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(searchResultAccessors);
    }
}

