/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.query;

import com.adaptavist.confluence.forums.service.search.query.AbstractForumsQuery;
import com.adaptavist.confluence.forums.service.search.query.ForumStringRangeQuery;
import com.adaptavist.confluence.forums.service.search.query.range.ForumStringRange;
import com.adaptavist.confluence.forums.view.beans.search.topics.FilterValueType;
import com.atlassian.confluence.search.v2.SearchQuery;
import java.util.List;

public class LastActivityDateForumQuery
extends ForumStringRangeQuery<AbstractForumsQuery, Long> {
    private static final String KEY = "last-activity-date-filter-key";

    public LastActivityDateForumQuery(ForumStringRange range) {
        super(KEY, range);
    }

    public static LastActivityDateForumQuery getInstance(List<String> filterValues, FilterValueType valueType) {
        ForumStringRange range = LastActivityDateForumQuery.filterRange(filterValues, valueType);
        if (!range.isEmpty()) {
            return new LastActivityDateForumQuery(range);
        }
        return null;
    }

    @Override
    protected String getIndexField() {
        return "forumIndexPageLastActivityDate";
    }

    @Override
    protected Long processRangeStart(String start) {
        return this.getDateToMillis(start);
    }

    @Override
    protected Long processRangeEnd(String end) {
        return this.getNextDayDateToMillis(end);
    }

    @Override
    protected SearchQuery buildRangeQuery(Long start, Long end) {
        return this.longRangeQuery(start, end);
    }
}

