/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.extractors;

import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.extractors.AbstractForumExtractor;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.StringFieldDescriptor;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;

public class TopicForumExtractor
extends AbstractForumExtractor {
    private static final String ANONYMOUS = "Anonymous";
    private static final com.adaptavist.confluence.forums.view.beans.User ANONYMOUS_USER = new com.adaptavist.confluence.forums.view.beans.User("Anonymous", "Anonymous", null, "/images/icons/profilepics/anonymous.png");
    private static final com.adaptavist.confluence.forums.view.beans.User EMPTY_USER = new com.adaptavist.confluence.forums.view.beans.User("", "", "", "");
    final UserAccessor userAccessor;
    final ForumManager forumManager;

    public TopicForumExtractor(ForumManager forumManager, @ComponentImport UserAccessor userAccessor) {
        this.forumManager = forumManager;
        this.userAccessor = userAccessor;
    }

    public Collection<FieldDescriptor> extractFields(Object searchable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (searchable instanceof Page) {
            Page page = (Page)searchable;
            com.adaptavist.confluence.forums.view.beans.User lastCommentBy = this.getLastCommentBy(page);
            if (this.forumManager.isTopic((AbstractPage)page) && !this.forumManager.isPageFromLockedForum((AbstractPage)page)) {
                Page topicForum = this.forumManager.getForumForTopic((AbstractPage)page);
                builder.add((Object)this.addStringField("forumIndexPageIsTopicInt", "1"));
                builder.add((Object)this.addStringField("forumIndexPageId", page.getIdAsString()));
                builder.add((Object)this.addTextField("forumIndexPageTitle", page.getTitle()));
                builder.add((Object)this.addStringField("forumIndexPageTitleNonAnalyzed", page.getTitle()));
                builder.add((Object)this.addLongField("forumIndexPageCreationDate", page.getCreationDate().getTime()));
                builder.add((Object)this.addStringField("forumIndexPageAuthorFullName", this.getAuthorFullName((ContentEntityObject)page)));
                builder.add((Object)this.addStringField("forumIndexPageAuthorUsername", this.getAuthorUserName((ContentEntityObject)page)));
                builder.add((Object)this.addIntegerField("forumIndexPageNumberOfReplies", page.getComments().size()));
                Set<String> participants = this.getParticipants(page);
                participants.forEach(participant -> builder.add((Object)new StringFieldDescriptor("forumIndexPageParticipants", participant, FieldDescriptor.Store.YES)));
                builder.add((Object)this.addStringField("topicLastCommentByFullName", lastCommentBy.getFullName()));
                builder.add((Object)this.addStringField("topicLastCommentByName", lastCommentBy.getUsername()));
                builder.add((Object)this.addStringField("topicLastCommentByPicture", lastCommentBy.getPicture()));
                builder.add((Object)this.addStringField("topicLastCommentByKey", lastCommentBy.getUserKey()));
                builder.add((Object)this.addLongField("forumIndexTopicForumId", this.getPageId(topicForum)));
                builder.add((Object)this.addTextField("forumIndexTopicForumTitle", this.getPageTitle(topicForum)));
                for (Comment comment : page.getPageLevelComments()) {
                    builder.add((Object)this.addTextField("topicComment", comment.getBodyAsString()));
                }
            }
        }
        return builder.build();
    }

    private com.adaptavist.confluence.forums.view.beans.User getLastCommentBy(Page page) {
        int size = page.getComments().size();
        if (size != 0) {
            Comment comment = (Comment)page.getComments().get(size - 1);
            if (comment.getCreator() != null) {
                ConfluenceUser user = comment.getCreator();
                ProfilePictureInfo picture = this.userAccessor.getUserProfilePicture((User)user);
                String picUrl = picture != null ? picture.getDownloadPath() : "/images/icons/profilepics/anonymous.png";
                return new com.adaptavist.confluence.forums.view.beans.User(user.getName(), user.getFullName(), user.getKey().getStringValue(), picUrl);
            }
            return ANONYMOUS_USER;
        }
        return EMPTY_USER;
    }
}

