/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.analytic.event;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AnalyticMetricsBuilder {
    private static final String PLUGIN_KEY = "com.adaptavist.confluence.forums";
    private static final String APP_NAME = "app-name";
    private static final String EVENT_DATE = "event-date";
    private static final String APP_VERSION = "app-version";
    private static final String ACTION = "Action";
    private static final String SPACE_TYPE = "spaceType";
    private static final String SPACE_ID = "spaceID";
    private static final String USER_TYPE = "userType";
    private static final String USER_ID = "userID";
    private static final String TRIGGERED_BY = "triggeredBy";
    private static final String GROUP_ID = "groupID";
    private Map<String, String> metricsMap = new HashMap<String, String>();

    public Map<String, String> build() {
        this.metricsMap.put(APP_NAME, PLUGIN_KEY);
        this.metricsMap.put(EVENT_DATE, new Date().toString());
        return this.metricsMap;
    }

    public AnalyticMetricsBuilder setTriggeredBy(String user) {
        this.metricsMap.put(TRIGGERED_BY, user);
        return this;
    }

    public AnalyticMetricsBuilder setAppVersion(String appVersion) {
        this.metricsMap.put(APP_VERSION, appVersion);
        return this;
    }

    public AnalyticMetricsBuilder setAction(String action) {
        this.metricsMap.put(ACTION, action);
        return this;
    }

    public AnalyticMetricsBuilder setSpaceType(String spaceType) {
        this.metricsMap.put(SPACE_TYPE, spaceType);
        return this;
    }

    public AnalyticMetricsBuilder setSpaceID(String spaceID) {
        this.metricsMap.put(SPACE_ID, spaceID);
        return this;
    }

    public AnalyticMetricsBuilder setUserType(String userType) {
        this.metricsMap.put(USER_TYPE, userType);
        return this;
    }

    public AnalyticMetricsBuilder setUserID(String userId) {
        this.metricsMap.put(USER_ID, userId);
        return this;
    }

    public AnalyticMetricsBuilder setGroupID(String groupId) {
        this.metricsMap.put(GROUP_ID, groupId);
        return this;
    }
}

