/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.dao.ao.builder;

import com.adaptavist.confluence.forums.ForumConstants;
import com.adaptavist.confluence.forums.dao.ao.builder.AbstractEntityBuilder;
import com.adaptavist.confluence.forums.dao.ao.entity.ForumConfigEntity;
import com.adaptavist.confluence.forums.dao.ao.entity.PermissionsConfig;

public class PermissionsConfigBuilder
extends AbstractEntityBuilder {
    private static final PermissionsConfigBuilder GLOBAL_DEFAULT = PermissionsConfigBuilder.globalPermissionsBuilder().withStickyPermission(ForumConstants.ForumConfigDefaults.STICKY_PERMISSION).withStickySpaceOverride(false).withLockingPermission(ForumConstants.ForumConfigDefaults.LOCKING_PERMISSION).withLockingSpaceOverride(false);
    private PermissionsConfig.PermissionType stickyPermission;
    private boolean stickySpaceOverride;
    private PermissionsConfig.PermissionType lockingPermission;
    private boolean lockingSpaceOverride;

    private PermissionsConfigBuilder(ForumConfigEntity.Scope scope, String spaceKey) {
        super(scope, spaceKey);
    }

    public static PermissionsConfigBuilder defaultGlobalPermissionsBuilder() {
        return PermissionsConfigBuilder.copy(PermissionsConfigBuilder.globalPermissionsBuilder(), GLOBAL_DEFAULT);
    }

    public static PermissionsConfigBuilder globalPermissionsBuilder() {
        return new PermissionsConfigBuilder(ForumConfigEntity.Scope.GLOBAL, null);
    }

    public static PermissionsConfigBuilder spacePermissionsBuilder(String spaceKey) {
        return new PermissionsConfigBuilder(ForumConfigEntity.Scope.SPACE, spaceKey);
    }

    public static PermissionsConfigBuilder globalPermissionsBuilderFrom(PermissionsConfig config) {
        return config == null ? PermissionsConfigBuilder.globalPermissionsBuilder() : PermissionsConfigBuilder.builder(ForumConfigEntity.Scope.GLOBAL, config);
    }

    public static PermissionsConfigBuilder spacePermissionsBuilderFrom(PermissionsConfig config) {
        return config == null ? PermissionsConfigBuilder.globalPermissionsBuilder() : PermissionsConfigBuilder.builder(ForumConfigEntity.Scope.SPACE, config);
    }

    private static PermissionsConfigBuilder builder(ForumConfigEntity.Scope scope, PermissionsConfig config) {
        String spaceKey = ForumConfigEntity.Scope.SPACE.equals((Object)scope) ? config.getSpaceKey() : null;
        return PermissionsConfigBuilder.copy(new PermissionsConfigBuilder(scope, spaceKey), config);
    }

    private static PermissionsConfigBuilder copy(PermissionsConfigBuilder to, PermissionsConfigBuilder from) {
        return to.withLockingPermission(from.getLockingPermission()).withLockingSpaceOverride(from.isLockingSpaceOverride()).withStickyPermission(from.getStickyPermission()).withStickySpaceOverride(from.isStickySpaceOverride());
    }

    private static PermissionsConfigBuilder copy(PermissionsConfigBuilder to, PermissionsConfig from) {
        return to.withLockingPermission(from.getLockingPermission()).withLockingSpaceOverride(from.isLockingSpaceOverride()).withStickyPermission(from.getStickyPermission()).withStickySpaceOverride(from.isStickySpaceOverride());
    }

    public PermissionsConfig.PermissionType getStickyPermission() {
        return this.stickyPermission;
    }

    public PermissionsConfigBuilder withStickyPermission(PermissionsConfig.PermissionType permission) {
        this.stickyPermission = permission;
        return this;
    }

    public boolean isStickySpaceOverride() {
        return this.stickySpaceOverride;
    }

    public PermissionsConfigBuilder withStickySpaceOverride(boolean spaceOverride) {
        this.stickySpaceOverride = spaceOverride;
        return this;
    }

    public PermissionsConfig.PermissionType getLockingPermission() {
        return this.lockingPermission;
    }

    public PermissionsConfigBuilder withLockingPermission(PermissionsConfig.PermissionType permission) {
        this.lockingPermission = permission;
        return this;
    }

    public boolean isLockingSpaceOverride() {
        return this.lockingSpaceOverride;
    }

    public PermissionsConfigBuilder withLockingSpaceOverride(boolean spaceOverride) {
        this.lockingSpaceOverride = spaceOverride;
        return this;
    }

    public PermissionsConfigBuilder toGlobal() {
        return PermissionsConfigBuilder.copy(PermissionsConfigBuilder.globalPermissionsBuilder(), this);
    }

    public PermissionsConfigBuilder toSpace(String spaceKey) {
        return PermissionsConfigBuilder.copy(PermissionsConfigBuilder.spacePermissionsBuilder(spaceKey), this.withLockingSpaceOverride(false).withStickySpaceOverride(false));
    }
}

