/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserDetailsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/discovery")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ForumDiscoveryResource {
    private static final List<String> DIALOG_NAMES = Arrays.asList("forum-palette-seen", "new-header-seen");
    private final UserDetailsManager userDetailsManager;

    @Inject
    public ForumDiscoveryResource(@ComponentImport UserDetailsManager userDetailsManager) {
        this.userDetailsManager = userDetailsManager;
    }

    @GET
    @Path(value="/{property}")
    public Response getUserProperty(@PathParam(value="property") String property) throws EntityException {
        if (DIALOG_NAMES.contains(property.toLowerCase())) {
            return Response.ok((Object)this.userDetailsManager.getStringProperty((User)AuthenticatedUserThreadLocal.get(), property)).build();
        }
        return Response.ok((Object)false).build();
    }

    @POST
    @Path(value="/{property}/{value}")
    public Response setUserProperty(@PathParam(value="property") String property, @PathParam(value="value") String value) throws EntityException {
        if (DIALOG_NAMES.contains(property.toLowerCase())) {
            this.userDetailsManager.setStringProperty((User)AuthenticatedUserThreadLocal.get(), property, value);
            return Response.ok().build();
        }
        return Response.notModified((String)"Unable to set discovery popup preference. Property value not allowed").build();
    }
}

