/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.listeners;

import com.adaptavist.confluence.forums.controller.listeners.ForumsTopicViewsCacheManager;
import com.adaptavist.confluence.forums.controller.listeners.handler.impl.CreatePageEventStrategy;
import com.adaptavist.confluence.forums.controller.listeners.handler.impl.MovePageEventStrategy;
import com.adaptavist.confluence.forums.controller.listeners.handler.impl.UpdatePageEventStrategy;
import com.adaptavist.confluence.forums.service.ForumManager;
import com.adaptavist.confluence.forums.service.impl.PagePropertySupport;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.DisposableBean;

public class ForumEventListener
implements DisposableBean {
    private final EventPublisher eventPublisher;
    private final ForumManager forumManager;
    private final PagePropertySupport pagePropertySupport;
    private final CreatePageEventStrategy createPageEventStrategy;
    private final UpdatePageEventStrategy updatePageEventStrategy;
    private final MovePageEventStrategy movePageEventStrategy;
    private final AccessModeService accessModeService;
    private final ForumsTopicViewsCacheManager forumsTopicViewsCacheManager;

    public ForumEventListener(@ComponentImport EventPublisher eventPublisher, ForumManager forumManager, PagePropertySupport pagePropertySupport, CreatePageEventStrategy createPageEventStrategy, UpdatePageEventStrategy updatePageEventStrategy, MovePageEventStrategy movePageEventStrategy, @ComponentImport AccessModeService accessModeService, @ComponentImport CacheManager cacheManager) {
        this.eventPublisher = eventPublisher;
        this.forumManager = forumManager;
        this.pagePropertySupport = pagePropertySupport;
        this.createPageEventStrategy = createPageEventStrategy;
        this.updatePageEventStrategy = updatePageEventStrategy;
        this.movePageEventStrategy = movePageEventStrategy;
        this.accessModeService = accessModeService;
        this.forumsTopicViewsCacheManager = new ForumsTopicViewsCacheManager(cacheManager);
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void createPageEvent(PageCreateEvent createdEvent) {
        this.createPageEventStrategy.processPageEvent(createdEvent);
    }

    @EventListener
    public void viewPageEvent(PageViewEvent pageViewEvent) {
        AbstractPage abstractPage = (AbstractPage)pageViewEvent.getContent();
        if (this.forumManager.isTopic(abstractPage) && this.accessModeService.isReadOnlyAccessModeEnabled()) {
            this.forumsTopicViewsCacheManager.addViewToCache(abstractPage);
        } else if (this.forumManager.isTopic(abstractPage)) {
            String viewProperty = this.pagePropertySupport.getStringProperty(abstractPage, "forumIndexPageNumberOfViews");
            int views = viewProperty == null ? 0 : Integer.parseInt(viewProperty) + 1;
            this.pagePropertySupport.setStringProperty(abstractPage, "forumIndexPageNumberOfViews", String.valueOf(views));
        }
    }

    @EventListener
    public void editPageEvent(PageUpdateEvent updateEvent) {
        this.updatePageEventStrategy.processPageEvent(updateEvent);
    }

    @EventListener
    public void movePageEvent(PageMoveEvent moveEvent) {
        this.movePageEventStrategy.processPageEvent(moveEvent);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

