/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.filter.resolver;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.servlet.simpledisplay.ConvertedPath;
import com.atlassian.confluence.servlet.simpledisplay.PathConverter;
import com.atlassian.confluence.servlet.simpledisplay.PathConverterManager;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequestPageResolver {
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_SPACE_KEY = "spaceKey";
    public static final String PARAM_POSTING_DAY = "postingDay";
    private static final String PARAM_PAGE_ID = "pageId";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private final PageManager pageManager;
    private final PathConverterManager pathConverterManager;

    @Autowired
    public RequestPageResolver(@ComponentImport PageManager pageManager, @ComponentImport PathConverterManager pathConverterManager) {
        this.pageManager = pageManager;
        this.pathConverterManager = pathConverterManager;
    }

    public AbstractPage resolvePage(HttpServletRequest httpServletRequest) {
        AbstractPage page = this.getPageFromRequestPageIdParam(httpServletRequest);
        if (page == null) {
            page = this.getPageFromRequestPathInfo(httpServletRequest);
        }
        return page;
    }

    protected AbstractPage getPageFromRequestPageIdParam(HttpServletRequest servletRequest) {
        String pageIdParam = servletRequest.getParameter(PARAM_PAGE_ID);
        if (StringUtils.isNotBlank((String)pageIdParam) && StringUtils.isNumeric((String)pageIdParam)) {
            return this.pageManager.getAbstractPage(Long.parseLong(pageIdParam));
        }
        return null;
    }

    protected AbstractPage getPageFromRequestPathInfo(HttpServletRequest httpRequest) {
        String pathInfo = httpRequest.getPathInfo();
        if (StringUtils.isBlank((String)pathInfo)) {
            return null;
        }
        for (PathConverter pathConverter : this.pathConverterManager.getPathConverters()) {
            if (!pathConverter.handles(pathInfo)) continue;
            ConvertedPath convertedPath = pathConverter.getPath(pathInfo);
            Map parameters = convertedPath.getParameters();
            String title = this.decodeParamValue(parameters, PARAM_TITLE);
            String spaceKey = this.decodeParamValue(parameters, PARAM_SPACE_KEY);
            String postingDay = this.decodeParamValue(parameters, PARAM_POSTING_DAY);
            return this.getPage(spaceKey, title, postingDay);
        }
        return null;
    }

    private AbstractPage getPage(String spaceKey, String title, String postingDay) {
        if (AbstractPage.isValidPageTitle((String)title)) {
            if (StringUtils.isNotBlank((String)postingDay)) {
                return this.pageManager.getBlogPost(spaceKey, title, this.getPostingDay(postingDay));
            }
            return this.pageManager.getPage(spaceKey, title);
        }
        return null;
    }

    private String decodeParamValue(Map convertedParameters, String paramName) {
        Object paramValue = convertedParameters.get(paramName);
        String stringValue = paramValue instanceof String ? (String)paramValue : null;
        return HtmlUtil.urlDecode((String)HtmlUtil.urlDecode((String)stringValue));
    }

    public Calendar getPostingDay(String postingDay) {
        try {
            Date date = DATE_FORMAT.parse(postingDay);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

