/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.action.locking;

import com.adaptavist.confluence.forums.service.LockedActionManager;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.ViewPageAction;

public class ViewLockedPageAction
extends ViewPageAction {
    private static final String UNLOCKED = "unlocked";
    private boolean isPageLocked;
    private LockedActionManager lockedActionManager;

    public String execute() throws Exception {
        if (this.isPageLocked) {
            this.lockedActionManager.loadLockedPageRequiredResources(LockedActionManager.ActionName.VIEW_PAGE);
            this.lockedActionManager.addLockedActionInfoMessage(this.getPage(), (ConfluenceActionSupport)this, LockedActionManager.ActionName.VIEW_PAGE);
            return super.execute();
        }
        return UNLOCKED;
    }

    public boolean isShowCommentArea() {
        if (this.isPageLocked) {
            return false;
        }
        return super.isShowCommentArea();
    }

    public boolean isEditComment() {
        if (this.isPageLocked) {
            return false;
        }
        return super.isEditComment();
    }

    public boolean hasAttachFilePermissions() {
        if (this.isPageLocked) {
            return false;
        }
        return super.hasAttachFilePermissions();
    }

    public long getReplyToComment() {
        if (this.isPageLocked) {
            return -1L;
        }
        return super.getReplyToComment();
    }

    public void setPage(AbstractPage page) {
        super.setPage(page);
        this.isPageLocked = this.lockedActionManager.isPageActionLocked(page);
    }

    public void setLockedActionManager(LockedActionManager lockedActionManager) {
        this.lockedActionManager = lockedActionManager;
    }
}

