/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.action.locking;

import com.adaptavist.confluence.forums.controller.action.AbstractPageAwareAction;
import com.adaptavist.confluence.forums.service.ForumManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.user.User;

public abstract class AbstractLockAction
extends AbstractPageAwareAction {
    private ForumManager forumManager;

    protected abstract void lock(AbstractPage var1);

    protected abstract void unlock(AbstractPage var1);

    public final String lockPage() {
        if (this.hasLockingPermissions()) {
            this.lock(this.getPage());
            return "success";
        }
        return "error";
    }

    public final String unlockPage() {
        if (this.hasLockingPermissions()) {
            this.unlock(this.getPage());
            return "success";
        }
        return "error";
    }

    private boolean hasLockingPermissions() {
        if (this.getPage() == null) {
            this.addActionError(this.getText("com.adaptavist.confluence.restforum.action.sticky.page.not.specified"));
            return false;
        }
        if (!this.forumManager.hasLockingPagePermission((User)this.getAuthenticatedUser(), this.getPage())) {
            this.addActionError(this.getText("com.adaptavist.confluence.restforum.action.locking.no.permission"));
            return false;
        }
        return true;
    }

    public ForumManager getForumManager() {
        return this.forumManager;
    }

    public void setForumManager(ForumManager forumManager) {
        this.forumManager = forumManager;
    }
}

