/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.controller.action.config;

import com.adaptavist.confluence.forums.controller.action.config.SpaceAdminConfigAction;
import com.adaptavist.confluence.forums.dao.ao.builder.PermissionsConfigBuilder;
import com.adaptavist.confluence.forums.dao.ao.entity.PermissionsConfig;
import com.adaptavist.confluence.forums.dao.repository.PermissionsConfigRepository;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.RequireSecurityToken;

public class SpaceConfigurationAction
extends SpaceAdminConfigAction {
    private PermissionsConfigBuilder permissionsBuilder;
    private PermissionsConfigRepository permissionsService;
    private PermissionsConfig globalPermissions;

    @ParameterSafe
    public String getSpaceConfiguration() {
        if (this.noSpaceSpecified()) {
            return "error";
        }
        if (this.isNotSpaceAdmin()) {
            return "accessDenied";
        }
        this.loadConfiguration();
        return "success";
    }

    @ParameterSafe
    @RequireSecurityToken(value=true)
    public String updateSpacePermissions() {
        if (this.noSpaceSpecified()) {
            return "error";
        }
        if (this.isNotSpaceAdmin()) {
            return "accessDenied";
        }
        this.permissionsBuilder = this.permissionsBuilder.toSpace(this.getSpaceKey());
        PermissionsConfig savedConfig = this.permissionsService.saveSpacePermissions(this.permissionsBuilder);
        this.permissionsBuilder = PermissionsConfigBuilder.spacePermissionsBuilderFrom(savedConfig);
        return "success";
    }

    @ParameterSafe
    public String getStickyPermission() {
        return this.getPermissionsBuilder().getStickyPermission().name();
    }

    @ParameterSafe
    public void setStickyPermission(String stickyPermission) {
        PermissionsConfig.PermissionType permission = PermissionsConfig.PermissionType.fromString(stickyPermission);
        if (permission != null) {
            this.getPermissionsBuilder().withStickyPermission(permission);
        }
    }

    @ParameterSafe
    public String getLockingPermission() {
        return this.getPermissionsBuilder().getLockingPermission().name();
    }

    @ParameterSafe
    public void setLockingPermission(String lockingPermission) {
        PermissionsConfig.PermissionType permission = PermissionsConfig.PermissionType.fromString(lockingPermission);
        if (permission != null) {
            this.getPermissionsBuilder().withLockingPermission(permission);
        }
    }

    @ParameterSafe
    public void setForumPermissionsService(PermissionsConfigRepository permissionsConfigService) {
        this.permissionsService = permissionsConfigService;
    }

    @ParameterSafe
    public boolean isStickySpaceOverride() {
        return this.getGlobalPermissions().isStickySpaceOverride();
    }

    @ParameterSafe
    public boolean isLockingSpaceOverride() {
        return this.getGlobalPermissions().isLockingSpaceOverride();
    }

    private void loadConfiguration() {
        PermissionsConfig permissions = this.permissionsService.getSpacePermissions(this.getSpaceKey());
        this.permissionsBuilder = PermissionsConfigBuilder.spacePermissionsBuilderFrom(permissions);
    }

    private PermissionsConfigBuilder getPermissionsBuilder() {
        if (this.permissionsBuilder == null) {
            this.permissionsBuilder = PermissionsConfigBuilder.spacePermissionsBuilderFrom(this.permissionsService.getSpacePermissions(this.getSpaceKey()));
        }
        return this.permissionsBuilder;
    }

    private PermissionsConfig getGlobalPermissions() {
        if (this.globalPermissions == null) {
            this.globalPermissions = this.permissionsService.getGlobalPermissions();
        }
        return this.globalPermissions;
    }
}

